#!/nix/store/m6dvxhbvragcs40q71d5bbq1v4pjjxhb-busybox-1.25.1/bin/ash
set -e
if [ "$1" = "goshawkdb" ]; then
  /nix/store/m6dvxhbvragcs40q71d5bbq1v4pjjxhb-busybox-1.25.1/bin/chown -R goshawkdb /data
  exec /nix/store/njjsxc49azhvnq66hrfqh1zwp3fhz4cq-go1.7-gosu-bin/bin/gosu goshawkdb \
    /nix/store/74r8ymgpsn2g7ndm01y6xhl9yzglk816-go1.7-goshawkdb-server-bin/bin/goshawkdb \
    -dir /data/goshawkdb \
    -config /data/config.json \
    -cert /data/clusterCert.pem
fi
if [ "$1" = "setup" ]; then
  if [ -e /data/goshawkdb -o -e /data/config.json -o -e /data/clusterCert.pem ]; then
    printf "/data is not empty. Cannot continue with setup"
    exit 1
  fi

  /nix/store/m6dvxhbvragcs40q71d5bbq1v4pjjxhb-busybox-1.25.1/bin/chown -R goshawkdb /data
  /nix/store/njjsxc49azhvnq66hrfqh1zwp3fhz4cq-go1.7-gosu-bin/bin/gosu goshawkdb /nix/store/74r8ymgpsn2g7ndm01y6xhl9yzglk816-go1.7-goshawkdb-server-bin/bin/goshawkdb \
    -gen-cluster-cert > /data/clusterCert.pem
  /nix/store/njjsxc49azhvnq66hrfqh1zwp3fhz4cq-go1.7-gosu-bin/bin/gosu goshawkdb /nix/store/74r8ymgpsn2g7ndm01y6xhl9yzglk816-go1.7-goshawkdb-server-bin/bin/goshawkdb \
    -cert /data/clusterCert.pem \
    -gen-client-cert 1> /data/clientKeyPair.pem 2> /data/clientKeyPairFingerprint.txt
  fp=$(/nix/store/m6dvxhbvragcs40q71d5bbq1v4pjjxhb-busybox-1.25.1/bin/grep 'Fingerprint:' /data/clientKeyPairFingerprint.txt | /nix/store/m6dvxhbvragcs40q71d5bbq1v4pjjxhb-busybox-1.25.1/bin/sed -e 's/^.\+Fingerprint: //')
  /nix/store/m6dvxhbvragcs40q71d5bbq1v4pjjxhb-busybox-1.25.1/bin/sed -e "s/FINGERPRINT/$fp/" < /nix/store/mg4v3bnwbivj8h325zp7036q8kzj16px-config.json > /data/config.json

  /nix/store/m6dvxhbvragcs40q71d5bbq1v4pjjxhb-busybox-1.25.1/bin/mkdir /data/goshawkdb
  /nix/store/m6dvxhbvragcs40q71d5bbq1v4pjjxhb-busybox-1.25.1/bin/chown -R goshawkdb:goshawkdb /data
  /nix/store/m6dvxhbvragcs40q71d5bbq1v4pjjxhb-busybox-1.25.1/bin/chmod 400 /data/clusterCert.pem /data/clientKeyPair.pem
  /nix/store/m6dvxhbvragcs40q71d5bbq1v4pjjxhb-busybox-1.25.1/bin/chmod 444 /data/config.json
  /nix/store/m6dvxhbvragcs40q71d5bbq1v4pjjxhb-busybox-1.25.1/bin/chmod 700 /data/goshawkdb

  exit 0
fi
exec "$@"
