/*
 * Decompiled with CFR 0.152.
 */
package com.zackehh.siphash;

class SipHashKey {
    final long k0;
    final long k1;

    public SipHashKey(byte[] key) {
        if (key.length != 16) {
            throw new IllegalArgumentException("Key must be exactly 16 bytes!");
        }
        this.k0 = SipHashKey.bytesToLong(key, 0);
        this.k1 = SipHashKey.bytesToLong(key, 8);
    }

    private static long bytesToLong(byte[] b, int offset) {
        long m = 0L;
        for (int i = 0; i < 8; ++i) {
            m |= ((long)b[i + offset] & 0xFFL) << 8 * i;
        }
        return m;
    }
}

