/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.collections.linearhash;

import io.goshawkdb.client.TransactionAbortedException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;

final class Root {
    static final int BucketCapacity = 64;
    static final double UtilizationFactor = 0.75;
    static final int SipHashKeyLength = 16;
    final int fieldCount = 6;
    int size;
    int bucketCount;
    BigInteger splitIndex;
    BigInteger maskHigh;
    BigInteger maskLow;
    byte[] hashkey;

    Root() {
        this.size = 0;
        this.bucketCount = 2;
        this.splitIndex = BigInteger.ZERO;
        this.maskHigh = BigInteger.valueOf(3L);
        this.maskLow = BigInteger.valueOf(1L);
        SecureRandom rng = new SecureRandom();
        this.hashkey = new byte[16];
        rng.nextBytes(this.hashkey);
    }

    Root(ByteBuffer data) {
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((ByteBuffer)data);){
            while (unpacker.hasNext()) {
                MessageFormat f = unpacker.getNextFormat();
                if (f != MessageFormat.FIXMAP && f != MessageFormat.MAP16 && f != MessageFormat.MAP32) {
                    throw new IllegalArgumentException("data does not contain a LinearHash root");
                }
                int pairs = unpacker.unpackMapHeader();
                if (pairs != 6) {
                    throw new IllegalArgumentException("Expected 6 pairs in root map. Found " + pairs);
                }
                while (pairs > 0) {
                    String key;
                    switch (key = unpacker.unpackString()) {
                        case "Size": {
                            this.size = unpacker.unpackInt();
                            break;
                        }
                        case "BucketCount": {
                            this.bucketCount = unpacker.unpackInt();
                            break;
                        }
                        case "SplitIndex": {
                            this.splitIndex = unpacker.unpackBigInteger();
                            break;
                        }
                        case "MaskHigh": {
                            this.maskHigh = unpacker.unpackBigInteger();
                            break;
                        }
                        case "MaskLow": {
                            this.maskLow = unpacker.unpackBigInteger();
                            break;
                        }
                        case "HashKey": {
                            this.hashkey = unpacker.readPayload(unpacker.unpackBinaryHeader());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected key in LinearHash root: " + key);
                        }
                    }
                    --pairs;
                }
            }
        }
        catch (Exception e) {
            throw new TransactionAbortedException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ByteBuffer pack() {
        try (MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();){
            packer.packMapHeader(6);
            packer.packString("Size");
            packer.packInt(this.size);
            packer.packString("BucketCount");
            packer.packInt(this.bucketCount);
            packer.packString("SplitIndex");
            packer.packBigInteger(this.splitIndex);
            packer.packString("MaskHigh");
            packer.packBigInteger(this.maskHigh);
            packer.packString("MaskLow");
            packer.packBigInteger(this.maskLow);
            packer.packString("HashKey");
            packer.packBinaryHeader(this.hashkey.length);
            packer.writePayload(this.hashkey);
            ByteBuffer byteBuffer = ByteBuffer.wrap(packer.toByteArray());
            return byteBuffer;
        }
        catch (IOException e) {
            throw new TransactionAbortedException((Exception)e);
        }
    }

    int bucketIndex(BigInteger key) {
        BigInteger hashLow = key.and(this.maskLow);
        if (hashLow.compareTo(this.splitIndex) >= 0) {
            return hashLow.intValueExact();
        }
        return key.and(this.maskHigh).intValueExact();
    }

    boolean needsSplit() {
        return (double)this.size / (double)(64 * this.bucketCount) > 0.75;
    }
}

