/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.collections.linearhash;

import io.goshawkdb.client.GoshawkObjRef;
import io.goshawkdb.client.TransactionAbortedException;
import io.goshawkdb.client.TransactionResult;
import io.goshawkdb.collections.linearhash.LinearHash;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.BiConsumer;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;

final class Bucket {
    private final LinearHash lh;
    GoshawkObjRef objRef;
    byte[][] entries;
    final ArrayList<GoshawkObjRef> refs = new ArrayList();
    private ByteBuffer value;

    private Bucket(LinearHash lhash, GoshawkObjRef ref, boolean populate) {
        this.lh = lhash;
        this.objRef = ref;
        if (populate) {
            this.populate();
        }
    }

    static Bucket load(LinearHash lhash, GoshawkObjRef ref) {
        return new Bucket(lhash, ref, true);
    }

    static Bucket createEmpty(LinearHash lhash, GoshawkObjRef ref) {
        Bucket b = new Bucket(lhash, ref, false);
        b.entries = new byte[64][];
        b.refs.add(ref);
        return b;
    }

    private void populate() {
        TransactionResult result = this.lh.conn.runTransaction(txn -> {
            this.objRef = txn.getObject(this.objRef);
            this.value = this.objRef.getValue();
            this.refs.clear();
            Collections.addAll(this.refs, this.objRef.getReferences());
            try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((ByteBuffer)this.value);){
                while (unpacker.hasNext()) {
                    MessageFormat f = unpacker.getNextFormat();
                    if (f != MessageFormat.FIXARRAY && f != MessageFormat.ARRAY16 && f != MessageFormat.ARRAY32) {
                        throw new IllegalArgumentException("value does not contain a LinearHash bucket");
                    }
                    this.entries = new byte[unpacker.unpackArrayHeader()][];
                    for (int idx = 0; idx < this.entries.length; ++idx) {
                        int keyLen = unpacker.unpackBinaryHeader();
                        if (keyLen <= 0) continue;
                        byte[] entry = new byte[keyLen];
                        unpacker.readPayload(entry);
                        this.entries[idx] = entry;
                    }
                }
            }
            catch (Exception e) {
                throw new TransactionAbortedException(e);
            }
            return null;
        });
        if (!result.isSuccessful()) {
            this.entries = null;
            this.value = null;
            this.refs.clear();
            throw new TransactionAbortedException(result.cause);
        }
    }

    void write(boolean updateEntries) {
        if (updateEntries) {
            try (MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();){
                packer.packArrayHeader(this.entries.length);
                for (byte[] entry : this.entries) {
                    if (entry == null) {
                        packer.packBinaryHeader(0);
                        continue;
                    }
                    packer.packBinaryHeader(entry.length);
                    packer.writePayload(entry);
                }
                this.value = ByteBuffer.wrap(packer.toByteArray());
            }
            catch (Exception e) {
                throw new TransactionAbortedException(e);
            }
        }
        this.objRef.set(this.value, this.refs.toArray(new GoshawkObjRef[this.refs.size()]));
    }

    GoshawkObjRef find(byte[] key) {
        for (int idx = 0; idx < this.entries.length; ++idx) {
            if (this.isSlotEmpty(idx) || !Arrays.equals(key, this.entries[idx])) continue;
            return this.refs.get(idx + 1);
        }
        Bucket b = this.next();
        if (b == null) {
            return null;
        }
        return b.find(key);
    }

    ChainMutationResult put(byte[] key, GoshawkObjRef value) {
        int slot = -1;
        for (int idx = 0; idx < this.entries.length; ++idx) {
            if (this.isSlotEmpty(idx)) {
                if (slot != -1) continue;
                slot = idx;
                continue;
            }
            if (!Arrays.equals(key, this.entries[idx])) continue;
            this.refs.set(idx + 1, value);
            this.write(false);
            return new ChainMutationResult(this, false, 0);
        }
        if (slot == -1) {
            return this.putInNext(key, value);
        }
        return this.putInSlot(key, value, slot);
    }

    private ChainMutationResult putInSlot(byte[] key, GoshawkObjRef value, int slot) {
        this.entries[slot] = key;
        int refSlot = slot + 1;
        if (refSlot == this.refs.size()) {
            this.refs.add(value);
        } else {
            this.refs.set(refSlot, value);
        }
        Bucket b = this.next();
        if (b == null) {
            this.write(true);
            return new ChainMutationResult(this, true, 0);
        }
        ChainMutationResult cmr = b.remove(key);
        if (cmr.b == null) {
            this.refs.set(0, this.objRef);
        } else {
            this.refs.set(0, cmr.b.objRef);
        }
        this.write(true);
        return new ChainMutationResult(this, !cmr.done, cmr.chainDelta);
    }

    private ChainMutationResult putInNext(byte[] key, GoshawkObjRef value) {
        Bucket b = this.next();
        if (b == null) {
            TransactionResult result = this.lh.conn.runTransaction(txn -> txn.createObject(null, new GoshawkObjRef[0]));
            if (!result.isSuccessful()) {
                throw new TransactionAbortedException(result.cause);
            }
            b = Bucket.createEmpty(this.lh, (GoshawkObjRef)result.result);
            ChainMutationResult cmr = b.put(key, value);
            this.refs.set(0, cmr.b.objRef);
            this.write(false);
            return new ChainMutationResult(this, cmr.done, cmr.chainDelta + 1);
        }
        ChainMutationResult cmr = b.put(key, value);
        return new ChainMutationResult(this, cmr.done, cmr.chainDelta);
    }

    ChainMutationResult remove(byte[] key) {
        int slot = -1;
        for (int idx = 0; idx < this.entries.length; ++idx) {
            if (this.isSlotEmpty(idx) || !Arrays.equals(key, this.entries[idx])) continue;
            slot = idx;
            break;
        }
        if (slot == -1) {
            Bucket b = this.next();
            if (b == null) {
                return new ChainMutationResult(this, false, 0);
            }
            ChainMutationResult cmr = b.remove(key);
            if (cmr.b == null) {
                this.refs.set(0, this.objRef);
                this.write(false);
            } else if (!this.refs.get(0).referencesSameAs(cmr.b.objRef)) {
                this.refs.set(0, cmr.b.objRef);
                b.write(false);
            }
            return new ChainMutationResult(this, cmr.done, cmr.chainDelta);
        }
        this.entries[slot] = null;
        int refSlot = slot + 1;
        this.refs.set(refSlot, this.objRef);
        this.tidyRefTail();
        if (this.refs.size() == 1) {
            return new ChainMutationResult(this.next(), true, -1);
        }
        this.write(true);
        return new ChainMutationResult(this, true, 0);
    }

    void forEach(BiConsumer<? super byte[], ? super GoshawkObjRef> action) {
        for (int idx = 0; idx < this.entries.length; ++idx) {
            if (this.isSlotEmpty(idx)) continue;
            action.accept((byte[])this.entries[idx], (GoshawkObjRef)this.refs.get(idx + 1));
        }
        Bucket b = this.next();
        if (b != null) {
            b.forEach(action);
        }
    }

    void tidyRefTail() {
        for (int idx = this.refs.size() - 1; idx > 0 && this.objRef.referencesSameAs(this.refs.get(idx)); --idx) {
            this.refs.remove(idx);
        }
    }

    boolean isSlotEmpty(int idx) {
        return idx + 1 >= this.refs.size() || this.refs.get(idx + 1).referencesSameAs(this.objRef);
    }

    Bucket next() {
        GoshawkObjRef ref = this.refs.get(0);
        if (ref.referencesSameAs(this.objRef)) {
            return null;
        }
        return Bucket.load(this.lh, ref);
    }

    static class ChainMutationResult {
        final Bucket b;
        final boolean done;
        final int chainDelta;

        ChainMutationResult(Bucket b, boolean done, int chainDelta) {
            this.b = b;
            this.done = done;
            this.chainDelta = chainDelta;
        }
    }
}

