/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.client;

import io.goshawkdb.client.Certs;
import io.goshawkdb.client.Connection;
import io.goshawkdb.client.TxnId;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.TimeUnit;

public class ConnectionFactory {
    public static final int DEFAULT_PORT = 7894;
    static final String PRODUCT_NAME = "GoshawkDB";
    static final String PRODUCT_VERSION = "0.3";
    static final int BUFFER_SIZE = 131072;
    static final int HEARTBEAT_INTERVAL = 2;
    static final TimeUnit HEARTBEAT_INTERVAL_UNIT = TimeUnit.SECONDS;
    static final int KEY_LEN = 20;
    static final TxnId VERSION_ZERO = new TxnId(new byte[20]);
    public final EventLoopGroup group;

    public ConnectionFactory() {
        this((EventLoopGroup)new NioEventLoopGroup());
    }

    public ConnectionFactory(EventLoopGroup group) {
        this.group = group;
    }

    public Connection connect(Certs certs, String host) throws InterruptedException {
        String portStr;
        int idx = host.lastIndexOf(58);
        if (idx != -1 && (portStr = host.substring(idx + 1)).matches("^\\d+$")) {
            return this.connect(certs, host.substring(0, idx), Integer.valueOf(portStr));
        }
        return this.connect(certs, host, 7894);
    }

    public Connection connect(Certs certs, String host, int port) throws InterruptedException {
        Connection conn = new Connection(this, certs, host, port);
        conn.connect();
        return conn;
    }
}

