/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.capnproto.FromPointerBuilderBlobDefault;
import org.capnproto.FromPointerReaderBlobDefault;
import org.capnproto.PointerFactory;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;
import org.capnproto.SetPointerBuilder;
import org.capnproto.WireHelpers;

public final class Text {
    public static final Factory factory = new Factory();

    public static final class Builder {
        public final ByteBuffer buffer;
        public final int offset;
        public final int size;

        public Builder() {
            this.buffer = ByteBuffer.allocate(0);
            this.offset = 0;
            this.size = 0;
        }

        public Builder(ByteBuffer byteBuffer, int n, int n2) {
            this.buffer = byteBuffer;
            this.offset = n;
            this.size = n2;
        }

        public ByteBuffer asByteBuffer() {
            ByteBuffer byteBuffer = this.buffer.duplicate();
            byteBuffer.position(this.offset);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(this.size);
            return byteBuffer2;
        }

        public final String toString() {
            byte[] byArray = new byte[this.size];
            ByteBuffer byteBuffer = this.buffer.duplicate();
            byteBuffer.position(this.offset);
            byteBuffer.get(byArray, 0, this.size);
            try {
                return new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error("UTF-8 is unsupported");
            }
        }
    }

    public static final class Reader {
        public final ByteBuffer buffer;
        public final int offset;
        public final int size;

        public Reader() {
            this.buffer = ByteBuffer.allocate(0);
            this.offset = 0;
            this.size = 0;
        }

        public Reader(ByteBuffer byteBuffer, int n, int n2) {
            this.buffer = byteBuffer;
            this.offset = n * 8;
            this.size = n2;
        }

        public Reader(String string) {
            try {
                byte[] byArray = string.getBytes("UTF-8");
                this.buffer = ByteBuffer.wrap(byArray);
                this.offset = 0;
                this.size = byArray.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error("UTF-8 is unsupported");
            }
        }

        public final int size() {
            return this.size;
        }

        public ByteBuffer asByteBuffer() {
            ByteBuffer byteBuffer = this.buffer.asReadOnlyBuffer();
            byteBuffer.position(this.offset);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(this.size);
            return byteBuffer2;
        }

        public final String toString() {
            byte[] byArray = new byte[this.size];
            ByteBuffer byteBuffer = this.buffer.duplicate();
            byteBuffer.position(this.offset);
            byteBuffer.get(byArray, 0, this.size);
            try {
                return new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error("UTF-8 is unsupported");
            }
        }
    }

    public static final class Factory
    implements FromPointerReaderBlobDefault<Reader>,
    FromPointerBuilderBlobDefault<Builder>,
    PointerFactory<Builder, Reader>,
    SetPointerBuilder<Builder, Reader> {
        @Override
        public final Reader fromPointerReaderBlobDefault(SegmentReader segmentReader, int n, ByteBuffer byteBuffer, int n2, int n3) {
            return WireHelpers.readTextPointer(segmentReader, n, byteBuffer, n2, n3);
        }

        @Override
        public final Reader fromPointerReader(SegmentReader segmentReader, int n, int n2) {
            return WireHelpers.readTextPointer(segmentReader, n, null, 0, 0);
        }

        @Override
        public final Builder fromPointerBuilderBlobDefault(SegmentBuilder segmentBuilder, int n, ByteBuffer byteBuffer, int n2, int n3) {
            return WireHelpers.getWritableTextPointer(n, segmentBuilder, byteBuffer, n2, n3);
        }

        @Override
        public final Builder fromPointerBuilder(SegmentBuilder segmentBuilder, int n) {
            return WireHelpers.getWritableTextPointer(n, segmentBuilder, null, 0, 0);
        }

        @Override
        public final Builder initFromPointerBuilder(SegmentBuilder segmentBuilder, int n, int n2) {
            return WireHelpers.initTextPointer(n, segmentBuilder, n2);
        }

        @Override
        public final void setPointerBuilder(SegmentBuilder segmentBuilder, int n, Reader reader) {
            WireHelpers.setTextPointer(n, segmentBuilder, reader);
        }
    }
}

