/*
 * Decompiled with CFR 0.152.
 */
package com.zackehh.siphash;

import com.zackehh.siphash.SipHashCase;
import com.zackehh.siphash.SipHashConstants;
import org.apache.commons.lang3.StringUtils;

public class SipHashResult {
    private final long result;

    SipHashResult(long result) {
        this.result = result;
    }

    public long get() {
        return this.result;
    }

    public String getHex() {
        return this.getHex(false, SipHashConstants.DEFAULT_CASE);
    }

    public String getHex(boolean padding) {
        return this.getHex(padding, SipHashConstants.DEFAULT_CASE);
    }

    public String getHex(SipHashCase s_case) {
        return this.getHex(false, s_case);
    }

    public String getHex(boolean padding, SipHashCase s_case) {
        String str = Long.toHexString(this.get());
        if (padding) {
            str = StringUtils.leftPad((String)str, (int)16, (String)"0");
        }
        if (s_case == SipHashCase.UPPER) {
            str = str.toUpperCase();
        }
        return str;
    }
}

