/*
 * Decompiled with CFR 0.152.
 */
package com.zackehh.siphash;

import com.zackehh.siphash.SipHashKey;
import com.zackehh.siphash.SipHashResult;

public class SipHashDigest {
    private final int c;
    private final int d;
    private long v0;
    private long v1;
    private long v2;
    private long v3;
    private byte input_len = 0;
    private int m_idx = 0;
    private long m;

    public SipHashDigest(byte[] key) {
        this(key, 2, 4);
    }

    public SipHashDigest(byte[] key, int c, int d) {
        this.c = c;
        this.d = d;
        SipHashKey hashKey = new SipHashKey(key);
        this.v0 = 0x736F6D6570736575L ^ hashKey.k0;
        this.v1 = 0x646F72616E646F6DL ^ hashKey.k1;
        this.v2 = 0x6C7967656E657261L ^ hashKey.k0;
        this.v3 = 0x7465646279746573L ^ hashKey.k1;
    }

    SipHashDigest(long v0, long v1, long v2, long v3, int c, int d) {
        this.c = c;
        this.d = d;
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
    }

    public SipHashDigest update(byte b) {
        this.input_len = (byte)(this.input_len + 1);
        this.m |= ((long)b & 0xFFL) << this.m_idx * 8;
        ++this.m_idx;
        if (this.m_idx >= 8) {
            this.v3 ^= this.m;
            for (int i = 0; i < this.c; ++i) {
                this.round();
            }
            this.v0 ^= this.m;
            this.m_idx = 0;
            this.m = 0L;
        }
        return this;
    }

    public SipHashDigest update(byte[] bytes) {
        for (byte b : bytes) {
            this.update(b);
        }
        return this;
    }

    public SipHashResult finish() {
        byte msgLenMod256 = this.input_len;
        while (this.m_idx < 7) {
            this.update((byte)0);
        }
        this.update(msgLenMod256);
        this.v2 ^= 0xFFL;
        for (int i = 0; i < this.d; ++i) {
            this.round();
        }
        return new SipHashResult(this.v0 ^ this.v1 ^ this.v2 ^ this.v3);
    }

    private void round() {
        this.v0 += this.v1;
        this.v2 += this.v3;
        this.v1 = this.rotateLeft(this.v1, 13);
        this.v3 = this.rotateLeft(this.v3, 16);
        this.v1 ^= this.v0;
        this.v3 ^= this.v2;
        this.v0 = this.rotateLeft(this.v0, 32);
        this.v2 += this.v1;
        this.v0 += this.v3;
        this.v1 = this.rotateLeft(this.v1, 17);
        this.v3 = this.rotateLeft(this.v3, 21);
        this.v1 ^= this.v2;
        this.v3 ^= this.v0;
        this.v2 = this.rotateLeft(this.v2, 32);
    }

    private long rotateLeft(long val, int shift) {
        return val << shift | val >>> 64 - shift;
    }
}

