/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.collections.linearhash;

import com.zackehh.siphash.SipHash;
import io.goshawkdb.client.Connection;
import io.goshawkdb.client.GoshawkObjRef;
import io.goshawkdb.client.TransactionAbortedException;
import io.goshawkdb.client.TransactionResult;
import io.goshawkdb.collections.linearhash.Bucket;
import io.goshawkdb.collections.linearhash.Root;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.BiConsumer;

public class LinearHash {
    public final Connection conn;
    public GoshawkObjRef objRef;
    private Root root;
    private GoshawkObjRef[] refs;
    private SipHash sipHash;

    public LinearHash(Connection c, GoshawkObjRef ref) {
        this.conn = c;
        this.objRef = ref;
    }

    public static LinearHash createEmpty(Connection c) throws Exception {
        TransactionResult result = c.runTransaction(txn -> {
            GoshawkObjRef rootObjRef = txn.createObject(null, new GoshawkObjRef[0]);
            LinearHash lh = new LinearHash(c, rootObjRef);
            lh.root = new Root();
            GoshawkObjRef[] refs = new GoshawkObjRef[lh.root.bucketCount];
            lh.refs = refs;
            for (int idx = 0; idx < refs.length; ++idx) {
                GoshawkObjRef objRef;
                refs[idx] = objRef = txn.createObject(null, new GoshawkObjRef[0]);
                Bucket.createEmpty(lh, objRef).write(true);
            }
            lh.write();
            return lh;
        });
        if (result.isSuccessful()) {
            LinearHash lh = (LinearHash)result.result;
            lh.sipHash = new SipHash(lh.root.hashkey);
            return lh;
        }
        throw result.cause;
    }

    private void populate() {
        TransactionResult result = this.conn.runTransaction(txn -> {
            this.objRef = txn.getObject(this.objRef);
            ByteBuffer value = this.objRef.getValue();
            this.refs = this.objRef.getReferences();
            this.root = new Root(value);
            return null;
        });
        if (!result.isSuccessful()) {
            this.root = null;
            this.refs = null;
            this.sipHash = null;
            throw new TransactionAbortedException(result.cause);
        }
        this.sipHash = new SipHash(this.root.hashkey);
    }

    private void write() {
        this.objRef.set(this.root.pack(), this.refs);
    }

    private BigInteger hash(byte[] key) {
        return new BigInteger(this.sipHash.hash(key).getHex(), 16);
    }

    public GoshawkObjRef find(byte[] key) throws Exception {
        TransactionResult result = this.conn.runTransaction(txn -> {
            this.populate();
            Bucket b = Bucket.load(this, this.refs[this.root.bucketIndex(this.hash(key))]);
            return b.find(key);
        });
        if (result.isSuccessful()) {
            return (GoshawkObjRef)result.result;
        }
        throw result.cause;
    }

    public void put(byte[] key, GoshawkObjRef value) throws Exception {
        TransactionResult result = this.conn.runTransaction(txn -> {
            this.populate();
            Bucket b = Bucket.load(this, this.refs[this.root.bucketIndex(this.hash(key))]);
            Bucket.ChainMutationResult cmr = b.put(key, value);
            if (cmr.done || cmr.chainDelta != 0) {
                if (cmr.done) {
                    ++this.root.size;
                }
                this.root.bucketCount += cmr.chainDelta;
                if (this.root.needsSplit()) {
                    this.split();
                }
                this.write();
            }
            return null;
        });
        if (!result.isSuccessful()) {
            throw result.cause;
        }
    }

    public void remove(byte[] key) throws Exception {
        TransactionResult result = this.conn.runTransaction(txn -> {
            this.populate();
            int idx = this.root.bucketIndex(this.hash(key));
            Bucket b = Bucket.load(this, this.refs[idx]);
            Bucket.ChainMutationResult cmr = b.remove(key);
            if (cmr.done || cmr.chainDelta != 0) {
                if (cmr.b == null) {
                    b.write(true);
                } else if (cmr.b != b) {
                    this.refs[idx] = cmr.b.objRef;
                }
                if (cmr.done) {
                    --this.root.size;
                }
                this.root.bucketCount += cmr.chainDelta;
                this.write();
            }
            return null;
        });
        if (!result.isSuccessful()) {
            throw result.cause;
        }
    }

    public void forEach(BiConsumer<? super byte[], ? super GoshawkObjRef> action) throws Exception {
        TransactionResult result = this.conn.runTransaction(txn -> {
            this.populate();
            for (GoshawkObjRef objRef : this.refs) {
                Bucket b = Bucket.load(this, objRef);
                b.forEach(action);
            }
            return null;
        });
        if (!result.isSuccessful()) {
            throw result.cause;
        }
    }

    public int size() throws Exception {
        TransactionResult result = this.conn.runTransaction(txn -> {
            this.populate();
            return this.root.size;
        });
        if (result.isSuccessful()) {
            return (Integer)result.result;
        }
        throw result.cause;
    }

    private void split() {
        int sOld = this.root.splitIndex.intValueExact();
        Bucket b = Bucket.load(this, this.refs[sOld]);
        TransactionResult result = this.conn.runTransaction(txn -> txn.createObject(null, new GoshawkObjRef[0]));
        if (!result.isSuccessful()) {
            throw new TransactionAbortedException(result.cause);
        }
        Bucket bNew = Bucket.createEmpty(this, (GoshawkObjRef)result.result);
        this.refs = Arrays.copyOf(this.refs, this.refs.length + 1);
        this.refs[this.refs.length - 1] = bNew.objRef;
        ++this.root.bucketCount;
        this.root.splitIndex = this.root.splitIndex.add(BigInteger.ONE);
        if (this.root.splitIndex.shiftLeft(1).compareTo(BigInteger.valueOf(this.refs.length)) == 0) {
            this.root.splitIndex = BigInteger.ZERO;
            this.root.maskLow = this.root.maskHigh;
            this.root.maskHigh = this.root.maskHigh.shiftLeft(1).add(BigInteger.ONE);
        }
        Bucket bPrev = null;
        Bucket bNext = null;
        while (b != null) {
            bNext = b.next();
            boolean emptied = true;
            for (int idx = 0; idx < b.entries.length; ++idx) {
                if (b.isSlotEmpty(idx)) continue;
                if (this.root.bucketIndex(this.hash(b.entries[idx])) == sOld) {
                    emptied = false;
                    continue;
                }
                Bucket.ChainMutationResult cmr = bNew.put(b.entries[idx], b.refs.get(idx + 1));
                this.root.bucketCount += cmr.chainDelta;
                b.entries[idx] = null;
                b.refs.set(idx + 1, b.objRef);
            }
            if (emptied) {
                if (bNext == null) {
                    if (bPrev == null) {
                        b.tidyRefTail();
                        b.write(true);
                    } else {
                        --this.root.bucketCount;
                        bPrev.refs.set(0, bPrev.objRef);
                    }
                } else {
                    --this.root.bucketCount;
                    if (bPrev == null) {
                        this.refs[sOld] = bNext.objRef;
                    } else {
                        bPrev.refs.set(0, bNext.objRef);
                    }
                }
            } else {
                b.tidyRefTail();
                if (bPrev != null) {
                    bPrev.write(true);
                }
                bPrev = b;
            }
            b = bNext;
        }
        if (bPrev != null) {
            bPrev.write(true);
        }
        bNew.write(true);
    }
}

