/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.FromPointerReader;
import org.capnproto.FromPointerReaderBlobDefault;
import org.capnproto.FromPointerReaderRefDefault;
import org.capnproto.SegmentReader;

public class StructReader {
    protected final SegmentReader segment;
    protected final int data;
    protected final int pointers;
    protected final int dataSize;
    protected final short pointerCount;
    protected final int nestingLimit;

    public StructReader() {
        this.segment = SegmentReader.EMPTY;
        this.data = 0;
        this.pointers = 0;
        this.dataSize = 0;
        this.pointerCount = 0;
        this.nestingLimit = Integer.MAX_VALUE;
    }

    public StructReader(SegmentReader segmentReader, int n, int n2, int n3, short s, int n4) {
        this.segment = segmentReader;
        this.data = n;
        this.pointers = n2;
        this.dataSize = n3;
        this.pointerCount = s;
        this.nestingLimit = n4;
    }

    protected final boolean _getBooleanField(int n) {
        if (n < this.dataSize) {
            byte by = this.segment.buffer.get(this.data + n / 8);
            return (by & 1 << n % 8) != 0;
        }
        return false;
    }

    protected final boolean _getBooleanField(int n, boolean bl) {
        return this._getBooleanField(n) ^ bl;
    }

    protected final byte _getByteField(int n) {
        if ((n + 1) * 8 <= this.dataSize) {
            return this.segment.buffer.get(this.data + n);
        }
        return 0;
    }

    protected final byte _getByteField(int n, byte by) {
        return (byte)(this._getByteField(n) ^ by);
    }

    protected final short _getShortField(int n) {
        if ((n + 1) * 16 <= this.dataSize) {
            return this.segment.buffer.getShort(this.data + n * 2);
        }
        return 0;
    }

    protected final short _getShortField(int n, short s) {
        return (short)(this._getShortField(n) ^ s);
    }

    protected final int _getIntField(int n) {
        if ((n + 1) * 32 <= this.dataSize) {
            return this.segment.buffer.getInt(this.data + n * 4);
        }
        return 0;
    }

    protected final int _getIntField(int n, int n2) {
        return this._getIntField(n) ^ n2;
    }

    protected final long _getLongField(int n) {
        if ((n + 1) * 64 <= this.dataSize) {
            return this.segment.buffer.getLong(this.data + n * 8);
        }
        return 0L;
    }

    protected final long _getLongField(int n, long l) {
        return this._getLongField(n) ^ l;
    }

    protected final float _getFloatField(int n) {
        if ((n + 1) * 32 <= this.dataSize) {
            return this.segment.buffer.getFloat(this.data + n * 4);
        }
        return 0.0f;
    }

    protected final float _getFloatField(int n, int n2) {
        if ((n + 1) * 32 <= this.dataSize) {
            return Float.intBitsToFloat(this.segment.buffer.getInt(this.data + n * 4) ^ n2);
        }
        return Float.intBitsToFloat(n2);
    }

    protected final double _getDoubleField(int n) {
        if ((n + 1) * 64 <= this.dataSize) {
            return this.segment.buffer.getDouble(this.data + n * 8);
        }
        return 0.0;
    }

    protected final double _getDoubleField(int n, long l) {
        if ((n + 1) * 64 <= this.dataSize) {
            return Double.longBitsToDouble(this.segment.buffer.getLong(this.data + n * 8) ^ l);
        }
        return Double.longBitsToDouble(l);
    }

    protected final boolean _pointerFieldIsNull(int n) {
        return this.segment.buffer.getLong((this.pointers + n) * 8) == 0L;
    }

    protected final <T> T _getPointerField(FromPointerReader<T> fromPointerReader, int n) {
        if (n < this.pointerCount) {
            return fromPointerReader.fromPointerReader(this.segment, this.pointers + n, this.nestingLimit);
        }
        return fromPointerReader.fromPointerReader(SegmentReader.EMPTY, 0, this.nestingLimit);
    }

    protected final <T> T _getPointerField(FromPointerReaderRefDefault<T> fromPointerReaderRefDefault, int n, SegmentReader segmentReader, int n2) {
        if (n < this.pointerCount) {
            return fromPointerReaderRefDefault.fromPointerReaderRefDefault(this.segment, this.pointers + n, segmentReader, n2, this.nestingLimit);
        }
        return fromPointerReaderRefDefault.fromPointerReaderRefDefault(SegmentReader.EMPTY, 0, segmentReader, n2, this.nestingLimit);
    }

    protected final <T> T _getPointerField(FromPointerReaderBlobDefault<T> fromPointerReaderBlobDefault, int n, ByteBuffer byteBuffer, int n2, int n3) {
        if (n < this.pointerCount) {
            return fromPointerReaderBlobDefault.fromPointerReaderBlobDefault(this.segment, this.pointers + n, byteBuffer, n2, n3);
        }
        return fromPointerReaderBlobDefault.fromPointerReaderBlobDefault(SegmentReader.EMPTY, 0, byteBuffer, n2, n3);
    }

    public static interface Factory<T> {
        public T constructReader(SegmentReader var1, int var2, int var3, int var4, short var5, int var6);
    }
}

