/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.client;

import io.goshawkdb.client.GoshawkObj;
import io.goshawkdb.client.GoshawkObjRef;
import io.goshawkdb.client.MessageReaderRefCount;
import io.goshawkdb.client.TransactionImpl;
import io.goshawkdb.client.TxnId;
import java.nio.ByteBuffer;

final class ObjectState {
    final GoshawkObj obj;
    ObjectState parent = null;
    TransactionImpl<?> transaction = null;
    TxnId curVersion = null;
    ByteBuffer curValue = null;
    MessageReaderRefCount curValueRef = null;
    GoshawkObjRef[] curObjectRefs = null;
    final boolean create;
    boolean read = false;
    boolean write = false;

    ObjectState(GoshawkObj gObj, TransactionImpl<?> txn, ByteBuffer val, GoshawkObjRef[] refs) {
        this.obj = gObj;
        this.create = true;
        this.transaction = txn;
        this.curValue = GoshawkObj.cloneByteBuffer(val).asReadOnlyBuffer();
        if (refs == null) {
            this.curObjectRefs = new GoshawkObjRef[0];
        } else {
            this.curObjectRefs = new GoshawkObjRef[refs.length];
            System.arraycopy(refs, 0, this.curObjectRefs, 0, refs.length);
        }
    }

    ObjectState(GoshawkObj gObj, TransactionImpl<?> txn) {
        this.obj = gObj;
        this.create = false;
        this.transaction = txn;
    }

    ObjectState(ObjectState state, TransactionImpl<?> txn) {
        this.obj = state.obj;
        this.parent = state;
        this.transaction = txn;
        this.curVersion = state.curVersion;
        this.curValue = state.curValue;
        this.curValueRef = state.curValueRef;
        if (this.curValueRef != null) {
            this.curValueRef.retain();
        }
        this.curObjectRefs = state.curObjectRefs;
        this.create = state.create;
        this.read = state.read;
        this.write = state.write;
    }
}

