/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.client;

import io.goshawkdb.client.capnp.CapabilitiesCap;

public enum Capability {
    None,
    Read,
    Write,
    ReadWrite;


    Capability union(Capability that) {
        if (this == that) {
            return this;
        }
        if (this == ReadWrite || that == ReadWrite) {
            return ReadWrite;
        }
        if (this == None) {
            return that;
        }
        if (that == None) {
            return this;
        }
        return ReadWrite;
    }

    public boolean canRead() {
        return this == Read || this == ReadWrite;
    }

    public boolean canWrite() {
        return this == Write || this == ReadWrite;
    }

    static Capability fromCapnp(CapabilitiesCap.Capability.Reader cap) {
        switch (cap.which()) {
            case NONE: {
                return None;
            }
            case READ: {
                return Read;
            }
            case WRITE: {
                return Write;
            }
            case READ_WRITE: {
                return ReadWrite;
            }
        }
        throw new IllegalArgumentException("Unexpected capability type");
    }

    void toCapnp(CapabilitiesCap.Capability.Builder builder) {
        switch (this) {
            case None: {
                builder.setNone(null);
                break;
            }
            case Read: {
                builder.setRead(null);
                break;
            }
            case Write: {
                builder.setWrite(null);
                break;
            }
            case ReadWrite: {
                builder.setReadWrite(null);
            }
        }
    }
}

