/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.client;

import io.goshawkdb.client.Capability;
import io.goshawkdb.client.MessageReaderRefCount;
import io.goshawkdb.client.TxnId;
import io.goshawkdb.client.VarUUId;
import io.goshawkdb.client.capnp.CapabilitiesCap;
import io.goshawkdb.client.capnp.TransactionCap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.capnproto.Data;
import org.capnproto.StructList;

final class Cache {
    private final Object lock = new Object();
    private final HashMap<VarUUId, ValueRef> m = new HashMap();

    Cache() {
    }

    void clear() {
        this.m.forEach((vUUId, valueRef) -> {
            if (valueRef.reader != null) {
                valueRef.reader.release();
            }
        });
        this.m.clear();
    }

    void setRoots(Map<String, RefCap> roots) {
        roots.forEach((name, rc) -> {
            ValueRef vr = new ValueRef();
            vr.cap = rc.cap;
            this.m.put(rc.vUUId, vr);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueRef get(VarUUId vUUId) {
        Object object = this.lock;
        synchronized (object) {
            return this.m.get(vUUId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFromTxnCommit(TransactionCap.ClientTxn.Reader txn, TxnId txnId) {
        Iterator actionIt = txn.getActions().iterator();
        Object object = this.lock;
        synchronized (object) {
            while (actionIt.hasNext()) {
                TransactionCap.ClientAction.Reader action = (TransactionCap.ClientAction.Reader)((Object)actionIt.next());
                VarUUId vUUId = new VarUUId(action.getVarId().asByteBuffer());
                switch (action.which()) {
                    case WRITE: {
                        TransactionCap.ClientAction.Write.Reader write = action.getWrite();
                        StructList.Reader<TransactionCap.ClientVarIdPos.Reader> refs = write.getReferences();
                        this.updateFromWrite(txnId, vUUId, write.getValue(), refs, null, false);
                        break;
                    }
                    case READWRITE: {
                        TransactionCap.ClientAction.Readwrite.Reader rw = action.getReadwrite();
                        StructList.Reader<TransactionCap.ClientVarIdPos.Reader> refs = rw.getReferences();
                        this.updateFromWrite(txnId, vUUId, rw.getValue(), refs, null, false);
                        break;
                    }
                    case CREATE: {
                        TransactionCap.ClientAction.Create.Reader create = action.getCreate();
                        StructList.Reader<TransactionCap.ClientVarIdPos.Reader> refs = create.getReferences();
                        this.updateFromWrite(txnId, vUUId, create.getValue(), refs, null, true);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<VarUUId> updateFromTxnAbort(StructList.Reader<TransactionCap.ClientUpdate.Reader> updates, MessageReaderRefCount reader) {
        ArrayList<VarUUId> modifiedVars = new ArrayList<VarUUId>(updates.size());
        Iterator updatesIt = updates.iterator();
        Object object = this.lock;
        synchronized (object) {
            while (updatesIt.hasNext()) {
                TransactionCap.ClientUpdate.Reader update = (TransactionCap.ClientUpdate.Reader)((Object)updatesIt.next());
                TxnId txnId = new TxnId(update.getVersion().asByteBuffer());
                StructList.Reader<TransactionCap.ClientAction.Reader> actions = update.getActions();
                actions.forEach(action -> {
                    VarUUId vUUId = new VarUUId(action.getVarId().asByteBuffer());
                    switch (action.which()) {
                        case DELETE: {
                            this.updateFromDelete(vUUId, txnId);
                            break;
                        }
                        case WRITE: {
                            TransactionCap.ClientAction.Write.Reader write = action.getWrite();
                            StructList.Reader<TransactionCap.ClientVarIdPos.Reader> refs = write.getReferences();
                            if (!this.updateFromWrite(txnId, vUUId, write.getValue(), refs, reader, false)) break;
                            modifiedVars.add(vUUId);
                            break;
                        }
                    }
                });
            }
        }
        return modifiedVars;
    }

    private void updateFromDelete(VarUUId vUUId, TxnId txnId) {
        ValueRef vr = this.m.get(vUUId);
        if (vr == null || vr.version == null) {
            throw new IllegalStateException("Divergence discovered on deletion of " + vUUId + ": server thinks we had it cached, but we don't!");
        }
        if (vr.version.equals(txnId)) {
            throw new IllegalStateException("Divergence discovered on deletion of " + vUUId + ": server thinks we don't have " + txnId + " but we do!");
        }
        vr.version = null;
        vr.value = null;
        vr.references = null;
        if (vr.reader != null) {
            vr.reader.release();
            vr.reader = null;
        }
    }

    private boolean updateFromWrite(TxnId txnId, VarUUId vUUId, Data.Reader value, StructList.Reader<TransactionCap.ClientVarIdPos.Reader> refs, MessageReaderRefCount reader, boolean created) {
        ValueRef vr = this.m.get(vUUId);
        boolean updated = vr != null && vr.version != null;
        RefCap[] references = new RefCap[refs.size()];
        if (vr == null) {
            vr = new ValueRef();
            this.m.put(vUUId, vr);
        } else if (vr.version != null && vr.version.equals(txnId)) {
            throw new IllegalStateException("Divergence discovered on update of " + vUUId + ": server thinks we don't have " + txnId + " but we do!");
        }
        vr.references = references;
        vr.version = txnId;
        vr.value = value.asByteBuffer().asReadOnlyBuffer().slice();
        if (reader != null) {
            reader.retain();
        }
        if (vr.reader != null) {
            vr.reader.release();
        }
        vr.reader = reader;
        if (created) {
            vr.cap = Capability.ReadWrite;
        }
        Iterator refsIt = refs.iterator();
        int idx = 0;
        while (refsIt.hasNext()) {
            RefCap rc;
            TransactionCap.ClientVarIdPos.Reader ref = (TransactionCap.ClientVarIdPos.Reader)((Object)refsIt.next());
            references[idx] = rc = new RefCap(new VarUUId(ref.getVarId().asByteBuffer()), ref.getCapability());
            ++idx;
            vr = this.m.get(rc.vUUId);
            if (vr == null) {
                vr = new ValueRef();
                vr.cap = rc.cap;
                this.m.put(rc.vUUId, vr);
                continue;
            }
            if (vr.cap == null) {
                vr.cap = rc.cap;
                continue;
            }
            vr.cap = vr.cap.union(rc.cap);
        }
        return updated;
    }

    static class RefCap {
        final VarUUId vUUId;
        final Capability cap;

        RefCap(VarUUId varUUId, CapabilitiesCap.Capability.Reader capReader) {
            this.vUUId = varUUId;
            this.cap = Capability.fromCapnp(capReader);
        }
    }

    static class ValueRef {
        TxnId version;
        ByteBuffer value;
        RefCap[] references;
        MessageReaderRefCount reader;
        Capability cap;

        ValueRef() {
        }
    }
}

