/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.BuilderArena;
import org.capnproto.Data;
import org.capnproto.DecodeException;
import org.capnproto.ElementSize;
import org.capnproto.FarPointer;
import org.capnproto.ListBuilder;
import org.capnproto.ListPointer;
import org.capnproto.ListReader;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;
import org.capnproto.StructBuilder;
import org.capnproto.StructPointer;
import org.capnproto.StructReader;
import org.capnproto.StructSize;
import org.capnproto.Text;
import org.capnproto.WirePointer;

final class WireHelpers {
    WireHelpers() {
    }

    static int roundBytesUpToWords(int n) {
        return (n + 7) / 8;
    }

    static int roundBitsUpToBytes(int n) {
        return (n + 7) / 8;
    }

    static int roundBitsUpToWords(long l) {
        return (int)((l + 63L) / 64L);
    }

    static AllocateResult allocate(int n, SegmentBuilder segmentBuilder, int n2, byte by) {
        long l = segmentBuilder.get(n);
        if (!WirePointer.isNull(l)) {
            WireHelpers.zeroObject(segmentBuilder, n);
        }
        if (n2 == 0 && by == 0) {
            WirePointer.setKindAndTargetForEmptyStruct(segmentBuilder.buffer, n);
            return new AllocateResult(n, n, segmentBuilder);
        }
        int n3 = segmentBuilder.allocate(n2);
        if (n3 == -1) {
            int n4 = n2 + 1;
            BuilderArena.AllocateResult allocateResult = segmentBuilder.getArena().allocate(n4);
            FarPointer.set(segmentBuilder.buffer, n, false, allocateResult.offset);
            FarPointer.setSegmentId(segmentBuilder.buffer, n, allocateResult.segment.id);
            int n5 = allocateResult.offset;
            int n6 = allocateResult.offset + 1;
            WirePointer.setKindAndTarget(allocateResult.segment.buffer, n5, by, n6);
            return new AllocateResult(n6, n5, allocateResult.segment);
        }
        WirePointer.setKindAndTarget(segmentBuilder.buffer, n, by, n3);
        return new AllocateResult(n3, n, segmentBuilder);
    }

    static FollowBuilderFarsResult followBuilderFars(long l, int n, SegmentBuilder segmentBuilder) {
        if (WirePointer.kind(l) == 2) {
            SegmentBuilder segmentBuilder2 = segmentBuilder.getArena().getSegment(FarPointer.getSegmentId(l));
            int n2 = FarPointer.positionInSegment(l);
            long l2 = segmentBuilder2.get(n2);
            if (!FarPointer.isDoubleFar(l)) {
                return new FollowBuilderFarsResult(WirePointer.target(n2, l2), l2, segmentBuilder2);
            }
            int n3 = n2 + 1;
            l = segmentBuilder2.get(n3);
            segmentBuilder2 = segmentBuilder2.getArena().getSegment(FarPointer.getSegmentId(l2));
            return new FollowBuilderFarsResult(FarPointer.positionInSegment(l2), l, segmentBuilder2);
        }
        return new FollowBuilderFarsResult(n, l, segmentBuilder);
    }

    static FollowFarsResult followFars(long l, int n, SegmentReader segmentReader) {
        if (segmentReader != null && WirePointer.kind(l) == 2) {
            int n2;
            SegmentReader segmentReader2 = segmentReader.arena.tryGetSegment(FarPointer.getSegmentId(l));
            int n3 = FarPointer.positionInSegment(l);
            long l2 = segmentReader2.get(n3);
            int n4 = n2 = FarPointer.isDoubleFar(l) ? 2 : 1;
            if (!FarPointer.isDoubleFar(l)) {
                return new FollowFarsResult(WirePointer.target(n3, l2), l2, segmentReader2);
            }
            long l3 = segmentReader2.get(n3 + 1);
            segmentReader2 = segmentReader2.arena.tryGetSegment(FarPointer.getSegmentId(l2));
            return new FollowFarsResult(FarPointer.positionInSegment(l2), l3, segmentReader2);
        }
        return new FollowFarsResult(n, l, segmentReader);
    }

    static void zeroObject(SegmentBuilder segmentBuilder, int n) {
        if (!segmentBuilder.isWritable()) {
            return;
        }
        long l = segmentBuilder.get(n);
        switch (WirePointer.kind(l)) {
            case 0: 
            case 1: {
                WireHelpers.zeroObject(segmentBuilder, l, WirePointer.target(n, l));
                break;
            }
            case 2: {
                segmentBuilder = segmentBuilder.getArena().getSegment(FarPointer.getSegmentId(l));
                if (!segmentBuilder.isWritable()) break;
                int n2 = FarPointer.positionInSegment(l);
                long l2 = segmentBuilder.get(n2);
                if (FarPointer.isDoubleFar(l)) {
                    SegmentBuilder segmentBuilder2 = segmentBuilder.getArena().getSegment(FarPointer.getSegmentId(l));
                    if (segmentBuilder2.isWritable()) {
                        WireHelpers.zeroObject(segmentBuilder2, n2 + 1, FarPointer.positionInSegment(l2));
                    }
                    segmentBuilder.buffer.putLong(n2 * 8, 0L);
                    segmentBuilder.buffer.putLong((n2 + 1) * 8, 0L);
                    break;
                }
                WireHelpers.zeroObject(segmentBuilder, n2);
                segmentBuilder.buffer.putLong(n2 * 8, 0L);
                break;
            }
        }
    }

    static void zeroObject(SegmentBuilder segmentBuilder, long l, int n) {
        if (!segmentBuilder.isWritable()) {
            return;
        }
        block0 : switch (WirePointer.kind(l)) {
            case 0: {
                int n2 = n + StructPointer.dataSize(l);
                int n3 = StructPointer.ptrCount(l);
                for (int i = 0; i < n3; ++i) {
                    WireHelpers.zeroObject(segmentBuilder, n2 + i);
                }
                WireHelpers.memset(segmentBuilder.buffer, n * 8, (byte)0, StructPointer.wordSize(l) * 8);
                break;
            }
            case 1: {
                switch (ListPointer.elementSize(l)) {
                    case 0: {
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        WireHelpers.memset(segmentBuilder.buffer, n * 8, (byte)0, WireHelpers.roundBitsUpToWords(ListPointer.elementCount(l) * ElementSize.dataBitsPerElement(ListPointer.elementSize(l))) * 8);
                        break block0;
                    }
                    case 6: {
                        int n4 = ListPointer.elementCount(l);
                        for (int i = 0; i < n4; ++i) {
                            WireHelpers.zeroObject(segmentBuilder, n + i);
                        }
                        WireHelpers.memset(segmentBuilder.buffer, n * 8, (byte)0, n4 * 8);
                        break block0;
                    }
                    case 7: {
                        long l2 = segmentBuilder.get(n);
                        if (WirePointer.kind(l2) != 0) {
                            throw new Error("Don't know how to handle non-STRUCT inline composite.");
                        }
                        short s = StructPointer.dataSize(l2);
                        int n5 = StructPointer.ptrCount(l2);
                        int n6 = n + 1;
                        int n7 = WirePointer.inlineCompositeListElementCount(l2);
                        for (int i = 0; i < n7; ++i) {
                            n6 += s;
                            for (int j = 0; j < n5; ++j) {
                                WireHelpers.zeroObject(segmentBuilder, n6);
                                ++n6;
                            }
                        }
                        WireHelpers.memset(segmentBuilder.buffer, n * 8, (byte)0, (StructPointer.wordSize(l2) * n7 + 1) * 8);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                throw new Error("Unexpected FAR pointer.");
            }
            case 3: {
                throw new Error("Unexpected OTHER pointer.");
            }
        }
    }

    static void zeroPointerAndFars(SegmentBuilder segmentBuilder, int n) {
        SegmentBuilder segmentBuilder2;
        long l = segmentBuilder.get(n);
        if (WirePointer.kind(l) == 2 && (segmentBuilder2 = segmentBuilder.getArena().getSegment(FarPointer.getSegmentId(l))).isWritable()) {
            int n2 = FarPointer.positionInSegment(l);
            segmentBuilder2.buffer.putLong(n2 * 8, 0L);
            if (FarPointer.isDoubleFar(l)) {
                segmentBuilder2.buffer.putLong(n2 * 8 + 1, 0L);
            }
        }
        segmentBuilder.put(n, 0L);
    }

    static void transferPointer(SegmentBuilder segmentBuilder, int n, SegmentBuilder segmentBuilder2, int n2) {
        long l = segmentBuilder2.get(n2);
        if (WirePointer.isNull(l)) {
            segmentBuilder.put(n, 0L);
        } else if (WirePointer.kind(l) == 2) {
            segmentBuilder.put(n, segmentBuilder2.get(n2));
        } else {
            WireHelpers.transferPointer(segmentBuilder, n, segmentBuilder2, n2, WirePointer.target(n2, l));
        }
    }

    static void transferPointer(SegmentBuilder segmentBuilder, int n, SegmentBuilder segmentBuilder2, int n2, int n3) {
        long l = segmentBuilder2.get(n2);
        long l2 = segmentBuilder2.get(n3);
        if (segmentBuilder == segmentBuilder2) {
            if (WirePointer.kind(l) == 0 && StructPointer.wordSize(l) == 0) {
                WirePointer.setKindAndTargetForEmptyStruct(segmentBuilder.buffer, n);
            } else {
                WirePointer.setKindAndTarget(segmentBuilder.buffer, n, WirePointer.kind(l), n3);
            }
            segmentBuilder.buffer.putInt(n * 8 + 4, segmentBuilder2.buffer.getInt(n2 * 8 + 4));
        } else {
            int n4 = segmentBuilder2.allocate(1);
            if (n4 == -1) {
                BuilderArena.AllocateResult allocateResult = segmentBuilder2.getArena().allocate(2);
                SegmentBuilder segmentBuilder3 = allocateResult.segment;
                n4 = allocateResult.offset;
                FarPointer.set(segmentBuilder3.buffer, n4, false, n3);
                FarPointer.setSegmentId(segmentBuilder3.buffer, n4, segmentBuilder2.id);
                WirePointer.setKindWithZeroOffset(segmentBuilder3.buffer, n4 + 1, WirePointer.kind(l2));
                segmentBuilder3.buffer.putInt((n4 + 1) * 8 + 4, segmentBuilder2.buffer.getInt(n2 * 8 + 4));
                FarPointer.set(segmentBuilder.buffer, n, true, n4);
                FarPointer.setSegmentId(segmentBuilder.buffer, n, segmentBuilder3.id);
            } else {
                WirePointer.setKindAndTarget(segmentBuilder2.buffer, n4, WirePointer.kind(l2), n3);
                segmentBuilder2.buffer.putInt(n4 * 8 + 4, segmentBuilder2.buffer.getInt(n2 * 8 + 4));
                FarPointer.set(segmentBuilder.buffer, n, false, n4);
                FarPointer.setSegmentId(segmentBuilder.buffer, n, segmentBuilder2.id);
            }
        }
    }

    static <T> T initStructPointer(StructBuilder.Factory<T> factory, int n, SegmentBuilder segmentBuilder, StructSize structSize) {
        AllocateResult allocateResult = WireHelpers.allocate(n, segmentBuilder, structSize.total(), (byte)0);
        StructPointer.setFromStructSize(allocateResult.segment.buffer, allocateResult.refOffset, structSize);
        return factory.constructBuilder(allocateResult.segment, allocateResult.ptr * 8, allocateResult.ptr + structSize.data, structSize.data * 64, structSize.pointers);
    }

    static <T> T getWritableStructPointer(StructBuilder.Factory<T> factory, int n, SegmentBuilder segmentBuilder, StructSize structSize, SegmentReader segmentReader, int n2) {
        long l = segmentBuilder.get(n);
        int n3 = WirePointer.target(n, l);
        if (WirePointer.isNull(l)) {
            if (segmentReader == null) {
                return WireHelpers.initStructPointer(factory, n, segmentBuilder, structSize);
            }
            throw new Error("unimplemented");
        }
        FollowBuilderFarsResult followBuilderFarsResult = WireHelpers.followBuilderFars(l, n3, segmentBuilder);
        short s = StructPointer.dataSize(followBuilderFarsResult.ref);
        int n4 = StructPointer.ptrCount(followBuilderFarsResult.ref);
        int n5 = followBuilderFarsResult.ptr + s;
        if (s < structSize.data || n4 < structSize.pointers) {
            short s2 = (short)Math.max(s, structSize.data);
            short s3 = (short)Math.max(n4, structSize.pointers);
            int n6 = s2 + s3 * 1;
            WireHelpers.zeroPointerAndFars(segmentBuilder, n);
            AllocateResult allocateResult = WireHelpers.allocate(n, segmentBuilder, n6, (byte)0);
            StructPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, s2, s3);
            WireHelpers.memcpy(allocateResult.segment.buffer, allocateResult.ptr * 8, followBuilderFarsResult.segment.buffer, followBuilderFarsResult.ptr * 8, s * 8);
            int n7 = allocateResult.ptr + s2;
            for (int i = 0; i < n4; ++i) {
                WireHelpers.transferPointer(allocateResult.segment, n7 + i, followBuilderFarsResult.segment, n5 + i);
            }
            WireHelpers.memset(followBuilderFarsResult.segment.buffer, followBuilderFarsResult.ptr * 8, (byte)0, (s + n4 * 1) * 8);
            return factory.constructBuilder(allocateResult.segment, allocateResult.ptr * 8, n7, s2 * 64, s3);
        }
        return factory.constructBuilder(followBuilderFarsResult.segment, followBuilderFarsResult.ptr * 8, n5, s * 64, (short)n4);
    }

    static <T> T initListPointer(ListBuilder.Factory<T> factory, int n, SegmentBuilder segmentBuilder, int n2, byte by) {
        assert (by != 7) : "Should have called initStructListPointer instead";
        int n3 = ElementSize.dataBitsPerElement(by);
        short s = ElementSize.pointersPerElement(by);
        int n4 = n3 + s * 64;
        int n5 = WireHelpers.roundBitsUpToWords((long)n2 * (long)n4);
        AllocateResult allocateResult = WireHelpers.allocate(n, segmentBuilder, n5, (byte)1);
        ListPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, by, n2);
        return factory.constructBuilder(allocateResult.segment, allocateResult.ptr * 8, n2, n4, n3, s);
    }

    static <T> T initStructListPointer(ListBuilder.Factory<T> factory, int n, SegmentBuilder segmentBuilder, int n2, StructSize structSize) {
        int n3 = structSize.total();
        int n4 = n2 * n3;
        AllocateResult allocateResult = WireHelpers.allocate(n, segmentBuilder, 1 + n4, (byte)1);
        ListPointer.setInlineComposite(allocateResult.segment.buffer, allocateResult.refOffset, n4);
        WirePointer.setKindAndInlineCompositeListElementCount(allocateResult.segment.buffer, allocateResult.ptr, (byte)0, n2);
        StructPointer.setFromStructSize(allocateResult.segment.buffer, allocateResult.ptr, structSize);
        return factory.constructBuilder(allocateResult.segment, (allocateResult.ptr + 1) * 8, n2, n3 * 64, structSize.data * 64, structSize.pointers);
    }

    static <T> T getWritableListPointer(ListBuilder.Factory<T> factory, int n, SegmentBuilder segmentBuilder, byte by, SegmentReader segmentReader, int n2) {
        assert (by != 7) : "Use getStructList{Element,Field} for structs";
        long l = segmentBuilder.get(n);
        int n3 = WirePointer.target(n, l);
        if (WirePointer.isNull(l)) {
            throw new Error("unimplemented");
        }
        FollowBuilderFarsResult followBuilderFarsResult = WireHelpers.followBuilderFars(l, n3, segmentBuilder);
        if (WirePointer.kind(followBuilderFarsResult.ref) != 1) {
            throw new DecodeException("Called getList{Field,Element}() but existing pointer is not a list");
        }
        byte by2 = ListPointer.elementSize(followBuilderFarsResult.ref);
        if (by2 == 7) {
            throw new Error("unimplemented");
        }
        int n4 = ElementSize.dataBitsPerElement(by2);
        short s = ElementSize.pointersPerElement(by2);
        if (n4 < ElementSize.dataBitsPerElement(by)) {
            throw new DecodeException("Existing list value is incompatible with expected type.");
        }
        if (s < ElementSize.pointersPerElement(by)) {
            throw new DecodeException("Existing list value is incompatible with expected type.");
        }
        int n5 = n4 + s * 64;
        return factory.constructBuilder(followBuilderFarsResult.segment, followBuilderFarsResult.ptr * 8, ListPointer.elementCount(followBuilderFarsResult.ref), n5, n4, s);
    }

    static <T> T getWritableStructListPointer(ListBuilder.Factory<T> factory, int n, SegmentBuilder segmentBuilder, StructSize structSize, SegmentReader segmentReader, int n2) {
        long l = segmentBuilder.get(n);
        int n3 = WirePointer.target(n, l);
        if (WirePointer.isNull(l)) {
            throw new Error("unimplemented");
        }
        FollowBuilderFarsResult followBuilderFarsResult = WireHelpers.followBuilderFars(l, n3, segmentBuilder);
        if (WirePointer.kind(followBuilderFarsResult.ref) != 1) {
            throw new DecodeException("Called getList{Field,Element}() but existing pointer is not a list");
        }
        byte by = ListPointer.elementSize(followBuilderFarsResult.ref);
        if (by == 7) {
            long l2 = followBuilderFarsResult.segment.get(followBuilderFarsResult.ptr);
            int n4 = followBuilderFarsResult.ptr + 1;
            if (WirePointer.kind(l2) != 0) {
                throw new DecodeException("INLINE_COMPOSITE list with non-STRUCT elements not supported.");
            }
            short s = StructPointer.dataSize(l2);
            int n5 = StructPointer.ptrCount(l2);
            int n6 = s + n5 * 1;
            int n7 = WirePointer.inlineCompositeListElementCount(l2);
            if (s >= structSize.data && n5 >= structSize.pointers) {
                return factory.constructBuilder(followBuilderFarsResult.segment, n4 * 8, n7, n6 * 64, s * 64, (short)n5);
            }
            short s2 = (short)Math.max(s, structSize.data);
            short s3 = (short)Math.max(n5, structSize.pointers);
            int n8 = s2 + s3 * 1;
            int n9 = n8 * n7;
            WireHelpers.zeroPointerAndFars(segmentBuilder, n);
            AllocateResult allocateResult = WireHelpers.allocate(n, segmentBuilder, n9 + 1, (byte)1);
            ListPointer.setInlineComposite(allocateResult.segment.buffer, allocateResult.refOffset, n9);
            long l3 = allocateResult.segment.get(allocateResult.ptr);
            WirePointer.setKindAndInlineCompositeListElementCount(allocateResult.segment.buffer, allocateResult.ptr, (byte)0, n7);
            StructPointer.set(allocateResult.segment.buffer, allocateResult.ptr, s2, s3);
            int n10 = allocateResult.ptr + 1;
            int n11 = n4;
            int n12 = n10;
            for (int i = 0; i < n7; ++i) {
                WireHelpers.memcpy(allocateResult.segment.buffer, n12 * 8, followBuilderFarsResult.segment.buffer, n11 * 8, s * 8);
                int n13 = n12 + s2;
                int n14 = n11 + s;
                for (int j = 0; j < n5; ++j) {
                    WireHelpers.transferPointer(allocateResult.segment, n13 + j, followBuilderFarsResult.segment, n14 + j);
                }
                n12 += n8;
                n11 += n6;
            }
            WireHelpers.memset(followBuilderFarsResult.segment.buffer, followBuilderFarsResult.ptr * 8, (byte)0, n6 * n7 * 8);
            return factory.constructBuilder(allocateResult.segment, n10 * 8, n7, n8 * 64, s2 * 64, s3);
        }
        int n15 = ElementSize.dataBitsPerElement(by);
        short s = ElementSize.pointersPerElement(by);
        int n16 = n15 + s * 64;
        int n17 = ListPointer.elementCount(l);
        if (by == 0) {
            return WireHelpers.initStructListPointer(factory, n, segmentBuilder, n17, structSize);
        }
        if (by == 1) {
            throw new Error("Found bit list where struct list was expected; upgrading boolean lists to struct is no longer supported.");
        }
        short s4 = structSize.data;
        short s5 = structSize.pointers;
        if (by == 6) {
            s5 = (short)Math.max(s5, 1);
        } else {
            s4 = (short)Math.max(s4, 1);
        }
        int n18 = s4 + s5 * 1;
        int n19 = n17 * n18;
        WireHelpers.zeroPointerAndFars(segmentBuilder, n);
        AllocateResult allocateResult = WireHelpers.allocate(n, segmentBuilder, n19 + 1, (byte)1);
        ListPointer.setInlineComposite(allocateResult.segment.buffer, allocateResult.refOffset, n19);
        long l4 = allocateResult.segment.get(allocateResult.ptr);
        WirePointer.setKindAndInlineCompositeListElementCount(allocateResult.segment.buffer, allocateResult.ptr, (byte)0, n17);
        StructPointer.set(allocateResult.segment.buffer, allocateResult.ptr, s4, s5);
        int n20 = allocateResult.ptr + 1;
        if (by == 6) {
            int n21 = n20 + s4;
            int n22 = followBuilderFarsResult.ptr;
            for (int i = 0; i < n17; ++i) {
                WireHelpers.transferPointer(segmentBuilder, n21, followBuilderFarsResult.segment, n22);
                n21 += n18 / 1;
                ++n22;
            }
        } else {
            int n23 = n20;
            int n24 = followBuilderFarsResult.ptr * 8;
            int n25 = n15 / 8;
            for (int i = 0; i < n17; ++i) {
                WireHelpers.memcpy(allocateResult.segment.buffer, n23 * 8, followBuilderFarsResult.segment.buffer, n24, n25);
                n24 += n25;
                n23 += n18;
            }
        }
        WireHelpers.memset(followBuilderFarsResult.segment.buffer, followBuilderFarsResult.ptr * 8, (byte)0, WireHelpers.roundBitsUpToBytes(n16 * n17));
        return factory.constructBuilder(allocateResult.segment, n20 * 8, n17, n18 * 64, s4 * 64, s5);
    }

    static Text.Builder initTextPointer(int n, SegmentBuilder segmentBuilder, int n2) {
        int n3 = n2 + 1;
        AllocateResult allocateResult = WireHelpers.allocate(n, segmentBuilder, WireHelpers.roundBytesUpToWords(n3), (byte)1);
        ListPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, (byte)2, n3);
        return new Text.Builder(allocateResult.segment.buffer, allocateResult.ptr * 8, n2);
    }

    static Text.Builder setTextPointer(int n, SegmentBuilder segmentBuilder, Text.Reader reader) {
        Text.Builder builder = WireHelpers.initTextPointer(n, segmentBuilder, reader.size);
        ByteBuffer byteBuffer = reader.buffer.duplicate();
        byteBuffer.position(reader.offset);
        byteBuffer.limit(reader.offset + reader.size);
        builder.buffer.position(builder.offset);
        builder.buffer.put(byteBuffer);
        return builder;
    }

    static Text.Builder getWritableTextPointer(int n, SegmentBuilder segmentBuilder, ByteBuffer byteBuffer, int n2, int n3) {
        long l = segmentBuilder.get(n);
        if (WirePointer.isNull(l)) {
            if (byteBuffer == null) {
                return new Text.Builder();
            }
            Text.Builder builder = WireHelpers.initTextPointer(n, segmentBuilder, n3);
            for (int i = 0; i < builder.size; ++i) {
                builder.buffer.put(builder.offset + i, byteBuffer.get(n2 * 8 + i));
            }
            return builder;
        }
        int n4 = WirePointer.target(n, l);
        FollowBuilderFarsResult followBuilderFarsResult = WireHelpers.followBuilderFars(l, n4, segmentBuilder);
        if (WirePointer.kind(followBuilderFarsResult.ref) != 1) {
            throw new DecodeException("Called getText{Field,Element} but existing pointer is not a list.");
        }
        if (ListPointer.elementSize(followBuilderFarsResult.ref) != 2) {
            throw new DecodeException("Called getText{Field,Element} but existing list pointer is not byte-sized.");
        }
        int n5 = ListPointer.elementCount(followBuilderFarsResult.ref);
        if (n5 == 0 || followBuilderFarsResult.segment.buffer.get(followBuilderFarsResult.ptr * 8 + n5 - 1) != 0) {
            throw new DecodeException("Text blob missing NUL terminator.");
        }
        return new Text.Builder(followBuilderFarsResult.segment.buffer, followBuilderFarsResult.ptr * 8, n5 - 1);
    }

    static Data.Builder initDataPointer(int n, SegmentBuilder segmentBuilder, int n2) {
        AllocateResult allocateResult = WireHelpers.allocate(n, segmentBuilder, WireHelpers.roundBytesUpToWords(n2), (byte)1);
        ListPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, (byte)2, n2);
        return new Data.Builder(allocateResult.segment.buffer, allocateResult.ptr * 8, n2);
    }

    static Data.Builder setDataPointer(int n, SegmentBuilder segmentBuilder, Data.Reader reader) {
        Data.Builder builder = WireHelpers.initDataPointer(n, segmentBuilder, reader.size);
        for (int i = 0; i < builder.size; ++i) {
            builder.buffer.put(builder.offset + i, reader.buffer.get(reader.offset + i));
        }
        return builder;
    }

    static Data.Builder getWritableDataPointer(int n, SegmentBuilder segmentBuilder, ByteBuffer byteBuffer, int n2, int n3) {
        long l = segmentBuilder.get(n);
        if (WirePointer.isNull(l)) {
            if (byteBuffer == null) {
                return new Data.Builder();
            }
            Data.Builder builder = WireHelpers.initDataPointer(n, segmentBuilder, n3);
            for (int i = 0; i < builder.size; ++i) {
                builder.buffer.put(builder.offset + i, byteBuffer.get(n2 * 8 + i));
            }
            return builder;
        }
        int n4 = WirePointer.target(n, l);
        FollowBuilderFarsResult followBuilderFarsResult = WireHelpers.followBuilderFars(l, n4, segmentBuilder);
        if (WirePointer.kind(followBuilderFarsResult.ref) != 1) {
            throw new DecodeException("Called getData{Field,Element} but existing pointer is not a list.");
        }
        if (ListPointer.elementSize(followBuilderFarsResult.ref) != 2) {
            throw new DecodeException("Called getData{Field,Element} but existing list pointer is not byte-sized.");
        }
        return new Data.Builder(followBuilderFarsResult.segment.buffer, followBuilderFarsResult.ptr * 8, ListPointer.elementCount(followBuilderFarsResult.ref));
    }

    static <T> T readStructPointer(StructReader.Factory<T> factory, SegmentReader segmentReader, int n, SegmentReader segmentReader2, int n2, int n3) {
        long l = segmentReader.get(n);
        if (WirePointer.isNull(l)) {
            if (segmentReader2 == null) {
                return factory.constructReader(SegmentReader.EMPTY, 0, 0, 0, (short)0, Integer.MAX_VALUE);
            }
            segmentReader = segmentReader2;
            n = n2;
            l = segmentReader.get(n);
        }
        if (n3 <= 0) {
            throw new DecodeException("Message is too deeply nested or contains cycles.");
        }
        int n4 = WirePointer.target(n, l);
        FollowFarsResult followFarsResult = WireHelpers.followFars(l, n4, segmentReader);
        short s = StructPointer.dataSize(followFarsResult.ref);
        if (WirePointer.kind(followFarsResult.ref) != 0) {
            throw new DecodeException("Message contains non-struct pointer where struct pointer was expected.");
        }
        followFarsResult.segment.arena.checkReadLimit(StructPointer.wordSize(followFarsResult.ref));
        return factory.constructReader(followFarsResult.segment, followFarsResult.ptr * 8, followFarsResult.ptr + s, s * 64, StructPointer.ptrCount(followFarsResult.ref), n3 - 1);
    }

    static SegmentBuilder setStructPointer(SegmentBuilder segmentBuilder, int n, StructReader structReader) {
        short s = (short)WireHelpers.roundBitsUpToWords(structReader.dataSize);
        int n2 = s + structReader.pointerCount * 1;
        AllocateResult allocateResult = WireHelpers.allocate(n, segmentBuilder, n2, (byte)0);
        StructPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, s, structReader.pointerCount);
        if (structReader.dataSize == 1) {
            throw new Error("single bit case not handled");
        }
        WireHelpers.memcpy(allocateResult.segment.buffer, allocateResult.ptr * 8, structReader.segment.buffer, structReader.data, structReader.dataSize / 8);
        int n3 = allocateResult.ptr + s;
        for (int i = 0; i < structReader.pointerCount; ++i) {
            WireHelpers.copyPointer(allocateResult.segment, n3 + i, structReader.segment, structReader.pointers + i, structReader.nestingLimit);
        }
        return allocateResult.segment;
    }

    static SegmentBuilder setListPointer(SegmentBuilder segmentBuilder, int n, ListReader listReader) {
        int n2 = WireHelpers.roundBitsUpToWords(listReader.elementCount * listReader.step);
        if (listReader.step <= 64) {
            AllocateResult allocateResult = WireHelpers.allocate(n, segmentBuilder, n2, (byte)1);
            if (listReader.structPointerCount == 1) {
                ListPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, (byte)6, listReader.elementCount);
                for (int i = 0; i < listReader.elementCount; ++i) {
                    WireHelpers.copyPointer(allocateResult.segment, allocateResult.ptr + i, listReader.segment, listReader.ptr / 8 + i, listReader.nestingLimit);
                }
            } else {
                byte by = 0;
                switch (listReader.step) {
                    case 0: {
                        by = 0;
                        break;
                    }
                    case 1: {
                        by = 1;
                        break;
                    }
                    case 8: {
                        by = 2;
                        break;
                    }
                    case 16: {
                        by = 3;
                        break;
                    }
                    case 32: {
                        by = 4;
                        break;
                    }
                    case 64: {
                        by = 5;
                        break;
                    }
                    default: {
                        throw new Error("invalid list step size: " + listReader.step);
                    }
                }
                ListPointer.set(allocateResult.segment.buffer, allocateResult.refOffset, by, listReader.elementCount);
                WireHelpers.memcpy(allocateResult.segment.buffer, allocateResult.ptr * 8, listReader.segment.buffer, listReader.ptr, n2 * 8);
            }
            return allocateResult.segment;
        }
        AllocateResult allocateResult = WireHelpers.allocate(n, segmentBuilder, n2 + 1, (byte)1);
        ListPointer.setInlineComposite(allocateResult.segment.buffer, allocateResult.refOffset, n2);
        short s = (short)WireHelpers.roundBitsUpToWords(listReader.structDataSize);
        int n3 = listReader.structPointerCount;
        WirePointer.setKindAndInlineCompositeListElementCount(allocateResult.segment.buffer, allocateResult.ptr, (byte)0, listReader.elementCount);
        StructPointer.set(allocateResult.segment.buffer, allocateResult.ptr, s, (short)n3);
        int n4 = allocateResult.ptr + 1;
        int n5 = listReader.ptr / 8;
        for (int i = 0; i < listReader.elementCount; ++i) {
            WireHelpers.memcpy(allocateResult.segment.buffer, n4 * 8, listReader.segment.buffer, n5 * 8, listReader.structDataSize / 8);
            n4 += s;
            n5 += s;
            for (int j = 0; j < n3; ++j) {
                WireHelpers.copyPointer(allocateResult.segment, n4, listReader.segment, n5, listReader.nestingLimit);
                ++n4;
                ++n5;
            }
        }
        return allocateResult.segment;
    }

    static void memset(ByteBuffer byteBuffer, int n, byte by, int n2) {
        for (int i = n; i < n + n2; ++i) {
            byteBuffer.put(i, by);
        }
    }

    static void memcpy(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2, int n2, int n3) {
        ByteBuffer byteBuffer3 = byteBuffer.duplicate();
        byteBuffer3.position(n);
        byteBuffer3.limit(n + n3);
        ByteBuffer byteBuffer4 = byteBuffer2.duplicate();
        byteBuffer4.position(n2);
        byteBuffer4.limit(n2 + n3);
        byteBuffer3.put(byteBuffer4);
    }

    static SegmentBuilder copyPointer(SegmentBuilder segmentBuilder, int n, SegmentReader segmentReader, int n2, int n3) {
        long l = segmentReader.get(n2);
        if (WirePointer.isNull(l)) {
            segmentBuilder.buffer.putLong(n * 8, 0L);
            return segmentBuilder;
        }
        int n4 = WirePointer.target(n2, l);
        FollowFarsResult followFarsResult = WireHelpers.followFars(l, n4, segmentReader);
        switch (WirePointer.kind(followFarsResult.ref)) {
            case 0: {
                if (n3 <= 0) {
                    throw new DecodeException("Message is too deeply nested or contains cycles. See org.capnproto.ReaderOptions.");
                }
                followFarsResult.segment.arena.checkReadLimit(StructPointer.wordSize(followFarsResult.ref));
                return WireHelpers.setStructPointer(segmentBuilder, n, new StructReader(followFarsResult.segment, followFarsResult.ptr * 8, followFarsResult.ptr + StructPointer.dataSize(followFarsResult.ref), StructPointer.dataSize(followFarsResult.ref) * 64, StructPointer.ptrCount(followFarsResult.ref), n3 - 1));
            }
            case 1: {
                byte by = ListPointer.elementSize(followFarsResult.ref);
                if (n3 <= 0) {
                    throw new DecodeException("Message is too deeply nested or contains cycles. See org.capnproto.ReaderOptions.");
                }
                if (by == 7) {
                    int n5 = ListPointer.inlineCompositeWordCount(followFarsResult.ref);
                    long l2 = followFarsResult.segment.get(followFarsResult.ptr);
                    int n6 = followFarsResult.ptr + 1;
                    followFarsResult.segment.arena.checkReadLimit(n5 + 1);
                    if (WirePointer.kind(l2) != 0) {
                        throw new DecodeException("INLINE_COMPOSITE lists of non-STRUCT type are not supported.");
                    }
                    int n7 = WirePointer.inlineCompositeListElementCount(l2);
                    int n8 = StructPointer.wordSize(l2);
                    if ((long)n8 * (long)n7 > (long)n5) {
                        throw new DecodeException("INLINE_COMPOSITE list's elements overrun its word count.");
                    }
                    if (n8 == 0) {
                        followFarsResult.segment.arena.checkReadLimit(n7);
                    }
                    return WireHelpers.setListPointer(segmentBuilder, n, new ListReader(followFarsResult.segment, n6 * 8, n7, n8 * 64, StructPointer.dataSize(l2) * 64, StructPointer.ptrCount(l2), n3 - 1));
                }
                int n9 = ElementSize.dataBitsPerElement(by);
                short s = ElementSize.pointersPerElement(by);
                int n10 = n9 + s * 64;
                int n11 = ListPointer.elementCount(followFarsResult.ref);
                int n12 = WireHelpers.roundBitsUpToWords((long)n11 * (long)n10);
                followFarsResult.segment.arena.checkReadLimit(n12);
                if (by == 0) {
                    followFarsResult.segment.arena.checkReadLimit(n11);
                }
                return WireHelpers.setListPointer(segmentBuilder, n, new ListReader(followFarsResult.segment, followFarsResult.ptr * 8, n11, n10, n9, s, n3 - 1));
            }
            case 2: {
                throw new Error("Far pointer should have been handled above.");
            }
            case 3: {
                throw new Error("copyPointer is unimplemented");
            }
        }
        throw new Error("unreachable");
    }

    static <T> T readListPointer(ListReader.Factory<T> factory, SegmentReader segmentReader, int n, SegmentReader segmentReader2, int n2, byte by, int n3) {
        long l = segmentReader.get(n);
        if (WirePointer.isNull(l)) {
            if (segmentReader2 == null) {
                return factory.constructReader(SegmentReader.EMPTY, 0, 0, 0, 0, (short)0, Integer.MAX_VALUE);
            }
            segmentReader = segmentReader2;
            n = n2;
            l = segmentReader.get(n);
        }
        if (n3 <= 0) {
            throw new Error("nesting limit exceeded");
        }
        int n4 = WirePointer.target(n, l);
        FollowFarsResult followFarsResult = WireHelpers.followFars(l, n4, segmentReader);
        byte by2 = ListPointer.elementSize(followFarsResult.ref);
        switch (by2) {
            case 7: {
                int n5 = ListPointer.inlineCompositeWordCount(followFarsResult.ref);
                long l2 = followFarsResult.segment.get(followFarsResult.ptr);
                int n6 = followFarsResult.ptr + 1;
                followFarsResult.segment.arena.checkReadLimit(n5 + 1);
                int n7 = WirePointer.inlineCompositeListElementCount(l2);
                int n8 = StructPointer.wordSize(l2);
                if ((long)n7 * (long)n8 > (long)n5) {
                    throw new DecodeException("INLINE_COMPOSITE list's elements overrun its word count.");
                }
                if (n8 == 0) {
                    followFarsResult.segment.arena.checkReadLimit(n7);
                }
                return factory.constructReader(followFarsResult.segment, n6 * 8, n7, n8 * 64, StructPointer.dataSize(l2) * 64, StructPointer.ptrCount(l2), n3 - 1);
            }
        }
        int n9 = ElementSize.dataBitsPerElement(ListPointer.elementSize(followFarsResult.ref));
        short s = ElementSize.pointersPerElement(ListPointer.elementSize(followFarsResult.ref));
        int n10 = ListPointer.elementCount(followFarsResult.ref);
        int n11 = n9 + s * 64;
        followFarsResult.segment.arena.checkReadLimit(WireHelpers.roundBitsUpToWords(n10 * n11));
        if (by2 == 0) {
            followFarsResult.segment.arena.checkReadLimit(n10);
        }
        int n12 = ElementSize.dataBitsPerElement(by);
        short s2 = ElementSize.pointersPerElement(by);
        if (n12 > n9) {
            throw new DecodeException("Message contains list with incompatible element type.");
        }
        if (s2 > s) {
            throw new DecodeException("Message contains list with incompatible element type.");
        }
        return factory.constructReader(followFarsResult.segment, followFarsResult.ptr * 8, ListPointer.elementCount(followFarsResult.ref), n11, n9, s, n3 - 1);
    }

    static Text.Reader readTextPointer(SegmentReader segmentReader, int n, ByteBuffer byteBuffer, int n2, int n3) {
        long l = segmentReader.get(n);
        if (WirePointer.isNull(l)) {
            if (byteBuffer == null) {
                return new Text.Reader();
            }
            return new Text.Reader(byteBuffer, n2, n3);
        }
        int n4 = WirePointer.target(n, l);
        FollowFarsResult followFarsResult = WireHelpers.followFars(l, n4, segmentReader);
        int n5 = ListPointer.elementCount(followFarsResult.ref);
        if (WirePointer.kind(followFarsResult.ref) != 1) {
            throw new DecodeException("Message contains non-list pointer where text was expected.");
        }
        if (ListPointer.elementSize(followFarsResult.ref) != 2) {
            throw new DecodeException("Message contains list pointer of non-bytes where text was expected.");
        }
        followFarsResult.segment.arena.checkReadLimit(WireHelpers.roundBytesUpToWords(n5));
        if (n5 == 0 || followFarsResult.segment.buffer.get(8 * followFarsResult.ptr + n5 - 1) != 0) {
            throw new DecodeException("Message contains text that is not NUL-terminated.");
        }
        return new Text.Reader(followFarsResult.segment.buffer, followFarsResult.ptr, n5 - 1);
    }

    static Data.Reader readDataPointer(SegmentReader segmentReader, int n, ByteBuffer byteBuffer, int n2, int n3) {
        long l = segmentReader.get(n);
        if (WirePointer.isNull(l)) {
            if (byteBuffer == null) {
                return new Data.Reader();
            }
            return new Data.Reader(byteBuffer, n2, n3);
        }
        int n4 = WirePointer.target(n, l);
        FollowFarsResult followFarsResult = WireHelpers.followFars(l, n4, segmentReader);
        int n5 = ListPointer.elementCount(followFarsResult.ref);
        if (WirePointer.kind(followFarsResult.ref) != 1) {
            throw new DecodeException("Message contains non-list pointer where data was expected.");
        }
        if (ListPointer.elementSize(followFarsResult.ref) != 2) {
            throw new DecodeException("Message contains list pointer of non-bytes where data was expected.");
        }
        followFarsResult.segment.arena.checkReadLimit(WireHelpers.roundBytesUpToWords(n5));
        return new Data.Reader(followFarsResult.segment.buffer, followFarsResult.ptr, n5);
    }

    static class FollowFarsResult {
        public final int ptr;
        public final long ref;
        public final SegmentReader segment;

        FollowFarsResult(int n, long l, SegmentReader segmentReader) {
            this.ptr = n;
            this.ref = l;
            this.segment = segmentReader;
        }
    }

    static class FollowBuilderFarsResult {
        public final int ptr;
        public final long ref;
        public final SegmentBuilder segment;

        FollowBuilderFarsResult(int n, long l, SegmentBuilder segmentBuilder) {
            this.ptr = n;
            this.ref = l;
            this.segment = segmentBuilder;
        }
    }

    static class AllocateResult {
        public final int ptr;
        public final int refOffset;
        public final SegmentBuilder segment;

        AllocateResult(int n, int n2, SegmentBuilder segmentBuilder) {
            this.ptr = n;
            this.refOffset = n2;
            this.segment = segmentBuilder;
        }
    }
}

