/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import org.capnproto.FromPointerBuilder;
import org.capnproto.SegmentBuilder;
import org.capnproto.SetPointerBuilder;
import org.capnproto.StructBuilder;

public class ListBuilder {
    final SegmentBuilder segment;
    final int ptr;
    final int elementCount;
    final int step;
    final int structDataSize;
    final short structPointerCount;

    public ListBuilder(SegmentBuilder segmentBuilder, int n, int n2, int n3, int n4, short s) {
        this.segment = segmentBuilder;
        this.ptr = n;
        this.elementCount = n2;
        this.step = n3;
        this.structDataSize = n4;
        this.structPointerCount = s;
    }

    public int size() {
        return this.elementCount;
    }

    protected boolean _getBooleanElement(int n) {
        long l = (long)n * (long)this.step;
        byte by = this.segment.buffer.get(this.ptr + (int)(l / 8L));
        return (by & 1 << (int)(l % 8L)) != 0;
    }

    protected byte _getByteElement(int n) {
        return this.segment.buffer.get(this.ptr + (int)((long)n * (long)this.step / 8L));
    }

    protected short _getShortElement(int n) {
        return this.segment.buffer.getShort(this.ptr + (int)((long)n * (long)this.step / 8L));
    }

    protected int _getIntElement(int n) {
        return this.segment.buffer.getInt(this.ptr + (int)((long)n * (long)this.step / 8L));
    }

    protected long _getLongElement(int n) {
        return this.segment.buffer.getLong(this.ptr + (int)((long)n * (long)this.step / 8L));
    }

    protected float _getFloatElement(int n) {
        return this.segment.buffer.getFloat(this.ptr + (int)((long)n * (long)this.step / 8L));
    }

    protected double _getDoubleElement(int n) {
        return this.segment.buffer.getDouble(this.ptr + (int)((long)n * (long)this.step / 8L));
    }

    protected void _setBooleanElement(int n, boolean bl) {
        long l = n * this.step;
        byte by = (byte)(l % 8L);
        int n2 = (int)((long)this.ptr + l / 8L);
        byte by2 = this.segment.buffer.get(n2);
        this.segment.buffer.put(n2, (byte)(by2 & ~(1 << by) | (bl ? (byte)1 : 0) << by));
    }

    protected void _setByteElement(int n, byte by) {
        this.segment.buffer.put(this.ptr + (int)((long)n * (long)this.step / 8L), by);
    }

    protected void _setShortElement(int n, short s) {
        this.segment.buffer.putShort(this.ptr + (int)((long)n * (long)this.step / 8L), s);
    }

    protected void _setIntElement(int n, int n2) {
        this.segment.buffer.putInt(this.ptr + (int)((long)n * (long)this.step / 8L), n2);
    }

    protected void _setLongElement(int n, long l) {
        this.segment.buffer.putLong(this.ptr + (int)((long)n * (long)this.step / 8L), l);
    }

    protected void _setFloatElement(int n, float f) {
        this.segment.buffer.putFloat(this.ptr + (int)((long)n * (long)this.step / 8L), f);
    }

    protected void _setDoubleElement(int n, double d) {
        this.segment.buffer.putDouble(this.ptr + (int)((long)n * (long)this.step / 8L), d);
    }

    protected final <T> T _getStructElement(StructBuilder.Factory<T> factory, int n) {
        long l = (long)n * (long)this.step;
        int n2 = this.ptr + (int)(l / 8L);
        int n3 = (n2 + this.structDataSize / 8) / 8;
        return factory.constructBuilder(this.segment, n2, n3, this.structDataSize, this.structPointerCount);
    }

    protected final <T> T _getPointerElement(FromPointerBuilder<T> fromPointerBuilder, int n) {
        return fromPointerBuilder.fromPointerBuilder(this.segment, (this.ptr + (int)((long)n * (long)this.step / 8L)) / 8);
    }

    protected final <T> T _initPointerElement(FromPointerBuilder<T> fromPointerBuilder, int n, int n2) {
        return fromPointerBuilder.initFromPointerBuilder(this.segment, (this.ptr + (int)((long)n * (long)this.step / 8L)) / 8, n2);
    }

    protected final <Builder, Reader> void _setPointerElement(SetPointerBuilder<Builder, Reader> setPointerBuilder, int n, Reader Reader2) {
        setPointerBuilder.setPointerBuilder(this.segment, (this.ptr + (int)((long)n * (long)this.step / 8L)) / 8, Reader2);
    }

    public static interface Factory<T> {
        public T constructBuilder(SegmentBuilder var1, int var2, int var3, int var4, int var5, short var6);
    }
}

