/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.client;

import io.goshawkdb.client.Cache;
import io.goshawkdb.client.Capability;
import io.goshawkdb.client.Connection;
import io.goshawkdb.client.ConnectionFactory;
import io.goshawkdb.client.GoshawkObjRef;
import io.goshawkdb.client.ObjectState;
import io.goshawkdb.client.TransactionRestartRequiredException;
import io.goshawkdb.client.TxnId;
import io.goshawkdb.client.VarUUId;
import io.goshawkdb.client.capnp.ConnectionCap;
import io.goshawkdb.client.capnp.TransactionCap;
import java.nio.ByteBuffer;
import java.util.List;
import org.capnproto.FromPointerBuilder;
import org.capnproto.MessageBuilder;
import org.capnproto.StructList;

final class GoshawkObj {
    private final Connection conn;
    public final VarUUId id;
    final GoshawkObjRef objRef;
    ObjectState state;

    GoshawkObj(VarUUId vUUId, Capability capability, Connection connection) {
        this.id = vUUId;
        this.objRef = new GoshawkObjRef(this, capability);
        this.conn = connection;
    }

    public String toString() {
        return "GoshawkObj(" + this.id + ")";
    }

    ByteBuffer getValue() {
        this.checkCanRead();
        this.checkExpired();
        this.maybeRecordRead(false);
        return GoshawkObj.cloneByteBuffer(this.state.curValue);
    }

    GoshawkObjRef[] getReferences() {
        this.checkCanRead();
        this.checkExpired();
        this.maybeRecordRead(false);
        GoshawkObjRef[] refs = new GoshawkObjRef[this.state.curObjectRefs.length];
        System.arraycopy(this.state.curObjectRefs, 0, refs, 0, refs.length);
        return refs;
    }

    TxnId getVersion() {
        this.checkCanRead();
        this.checkExpired();
        if (this.state.create) {
            return null;
        }
        this.maybeRecordRead(true);
        return this.state.curVersion;
    }

    void set(ByteBuffer value, GoshawkObjRef ... references) {
        this.checkCanWrite();
        this.checkExpired();
        this.state.write = true;
        this.state.curValue = value == null ? ByteBuffer.allocate(0).asReadOnlyBuffer() : GoshawkObj.cloneByteBuffer(value).asReadOnlyBuffer();
        if (this.state.curValueRef != null) {
            this.state.curValueRef.release();
            this.state.curValueRef = null;
        }
        if (references == null) {
            this.state.curObjectRefs = new GoshawkObjRef[0];
        } else {
            this.state.curObjectRefs = new GoshawkObjRef[references.length];
            System.arraycopy(references, 0, this.state.curObjectRefs, 0, references.length);
        }
    }

    private void maybeRecordRead(boolean ignoreWritten) {
        if (this.state.create || this.state.read || this.state.write && !ignoreWritten) {
            return;
        }
        Cache.ValueRef valueRef = this.state.transaction.cache.get(this.id);
        if (valueRef == null || valueRef.version == null) {
            List<VarUUId> modifiedVars = GoshawkObj.loadVar(this.id, this.conn);
            if (this.state.transaction.varsUpdated(modifiedVars)) {
                throw TransactionRestartRequiredException.e;
            }
            valueRef = this.state.transaction.cache.get(this.id);
            if (valueRef == null || valueRef.version == null) {
                throw new IllegalStateException("Loading " + this.id + " failed to find value / update cache");
            }
        }
        this.state.read = true;
        this.state.curVersion = valueRef.version;
        if (!this.state.write) {
            this.state.curValue = valueRef.value.duplicate();
            if (this.state.curValueRef != null) {
                this.state.curValueRef.release();
            }
            this.state.curValueRef = valueRef.reader;
            if (this.state.curValueRef != null) {
                this.state.curValueRef.retain();
            }
            GoshawkObjRef[] refs = new GoshawkObjRef[valueRef.references.length];
            int idx = 0;
            for (Cache.RefCap rc : valueRef.references) {
                GoshawkObj obj = this.state.transaction.getObject(rc.vUUId, true);
                refs[idx] = new GoshawkObjRef(obj, rc.cap);
                ++idx;
            }
            this.state.curObjectRefs = refs;
        }
    }

    private void checkExpired() {
        if (this.state == null) {
            throw new IllegalStateException("Use of expired object:" + this.id);
        }
        if (this.state.transaction.resetInProgress) {
            throw TransactionRestartRequiredException.e;
        }
    }

    private void checkCanRead() {
        if (!this.objRef.cap.canRead()) {
            throw new IllegalArgumentException("Cannot read object " + this.id);
        }
    }

    private void checkCanWrite() {
        if (!this.objRef.cap.canWrite()) {
            throw new IllegalArgumentException("Cannot write object " + this.id);
        }
    }

    private static List<VarUUId> loadVar(VarUUId vUUId, Connection conn) {
        MessageBuilder msg = new MessageBuilder();
        ConnectionCap.ClientMessage.Builder builder = (ConnectionCap.ClientMessage.Builder)((Object)msg.initRoot((FromPointerBuilder)ConnectionCap.ClientMessage.factory));
        TransactionCap.ClientTxn.Builder cTxn = builder.initClientTxnSubmission();
        cTxn.setRetry(false);
        StructList.Builder<TransactionCap.ClientAction.Builder> actions = cTxn.initActions(1);
        TransactionCap.ClientAction.Builder action = (TransactionCap.ClientAction.Builder)((Object)actions.get(0));
        action.setVarId(vUUId.id);
        action.initRead().setVersion(ConnectionFactory.VERSION_ZERO.id);
        return conn.submitTransaction((MessageBuilder)msg, (TransactionCap.ClientTxn.Builder)cTxn).modifiedVars;
    }

    static ByteBuffer cloneByteBuffer(ByteBuffer buf) {
        if (buf == null) {
            return ByteBuffer.allocate(0);
        }
        ByteBuffer clone = buf.isDirect() ? ByteBuffer.allocateDirect(buf.capacity()) : ByteBuffer.allocate(buf.capacity());
        ByteBuffer readOnlyCopy = buf.asReadOnlyBuffer();
        readOnlyCopy.rewind();
        clone.put(readOnlyCopy);
        clone.rewind();
        return clone;
    }
}

