/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.FromPointerBuilder;
import org.capnproto.FromPointerBuilderBlobDefault;
import org.capnproto.FromPointerBuilderRefDefault;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;
import org.capnproto.SetPointerBuilder;
import org.capnproto.StructSize;
import org.capnproto.WireHelpers;

public class StructBuilder {
    protected final SegmentBuilder segment;
    protected final int data;
    protected final int pointers;
    protected final int dataSize;
    protected final short pointerCount;

    public StructBuilder(SegmentBuilder segmentBuilder, int n, int n2, int n3, short s) {
        this.segment = segmentBuilder;
        this.data = n;
        this.pointers = n2;
        this.dataSize = n3;
        this.pointerCount = s;
    }

    protected final boolean _getBooleanField(int n) {
        int n2 = n;
        int n3 = this.data + n2 / 8;
        return (this.segment.buffer.get(n3) & 1 << n2 % 8) != 0;
    }

    protected final boolean _getBooleanField(int n, boolean bl) {
        return this._getBooleanField(n) ^ bl;
    }

    protected final void _setBooleanField(int n, boolean bl) {
        int n2 = n;
        byte by = (byte)(n2 % 8);
        int n3 = this.data + n2 / 8;
        byte by2 = this.segment.buffer.get(n3);
        this.segment.buffer.put(n3, (byte)(by2 & ~(1 << by) | (bl ? (byte)1 : 0) << by));
    }

    protected final void _setBooleanField(int n, boolean bl, boolean bl2) {
        this._setBooleanField(n, bl ^ bl2);
    }

    protected final byte _getByteField(int n) {
        return this.segment.buffer.get(this.data + n);
    }

    protected final byte _getByteField(int n, byte by) {
        return (byte)(this._getByteField(n) ^ by);
    }

    protected final void _setByteField(int n, byte by) {
        this.segment.buffer.put(this.data + n, by);
    }

    protected final void _setByteField(int n, byte by, byte by2) {
        this._setByteField(n, (byte)(by ^ by2));
    }

    protected final short _getShortField(int n) {
        return this.segment.buffer.getShort(this.data + n * 2);
    }

    protected final short _getShortField(int n, short s) {
        return (short)(this._getShortField(n) ^ s);
    }

    protected final void _setShortField(int n, short s) {
        this.segment.buffer.putShort(this.data + n * 2, s);
    }

    protected final void _setShortField(int n, short s, short s2) {
        this._setShortField(n, (short)(s ^ s2));
    }

    protected final int _getIntField(int n) {
        return this.segment.buffer.getInt(this.data + n * 4);
    }

    protected final int _getIntField(int n, int n2) {
        return this._getIntField(n) ^ n2;
    }

    protected final void _setIntField(int n, int n2) {
        this.segment.buffer.putInt(this.data + n * 4, n2);
    }

    protected final void _setIntField(int n, int n2, int n3) {
        this._setIntField(n, n2 ^ n3);
    }

    protected final long _getLongField(int n) {
        return this.segment.buffer.getLong(this.data + n * 8);
    }

    protected final long _getLongField(int n, long l) {
        return this._getLongField(n) ^ l;
    }

    protected final void _setLongField(int n, long l) {
        this.segment.buffer.putLong(this.data + n * 8, l);
    }

    protected final void _setLongField(int n, long l, long l2) {
        this._setLongField(n, l ^ l2);
    }

    protected final float _getFloatField(int n) {
        return this.segment.buffer.getFloat(this.data + n * 4);
    }

    protected final float _getFloatField(int n, int n2) {
        return Float.intBitsToFloat(this.segment.buffer.getInt(this.data + n * 4) ^ n2);
    }

    protected final void _setFloatField(int n, float f) {
        this.segment.buffer.putFloat(this.data + n * 4, f);
    }

    protected final void _setFloatField(int n, float f, int n2) {
        this.segment.buffer.putInt(this.data + n * 4, Float.floatToIntBits(f) ^ n2);
    }

    protected final double _getDoubleField(int n) {
        return this.segment.buffer.getDouble(this.data + n * 8);
    }

    protected final double _getDoubleField(int n, long l) {
        return Double.longBitsToDouble(this.segment.buffer.getLong(this.data + n * 8) ^ l);
    }

    protected final void _setDoubleField(int n, double d) {
        this.segment.buffer.putDouble(this.data + n * 8, d);
    }

    protected final void _setDoubleField(int n, double d, long l) {
        this.segment.buffer.putLong(this.data + n * 8, Double.doubleToLongBits(d) ^ l);
    }

    protected final boolean _pointerFieldIsNull(int n) {
        return this.segment.buffer.getLong((this.pointers + n) * 8) == 0L;
    }

    protected final void _clearPointerField(int n) {
        int n2 = this.pointers + n;
        WireHelpers.zeroObject(this.segment, n2);
        this.segment.buffer.putLong(n2 * 8, 0L);
    }

    protected final <T> T _getPointerField(FromPointerBuilder<T> fromPointerBuilder, int n) {
        return fromPointerBuilder.fromPointerBuilder(this.segment, this.pointers + n);
    }

    protected final <T> T _getPointerField(FromPointerBuilderRefDefault<T> fromPointerBuilderRefDefault, int n, SegmentReader segmentReader, int n2) {
        return fromPointerBuilderRefDefault.fromPointerBuilderRefDefault(this.segment, this.pointers + n, segmentReader, n2);
    }

    protected final <T> T _getPointerField(FromPointerBuilderBlobDefault<T> fromPointerBuilderBlobDefault, int n, ByteBuffer byteBuffer, int n2, int n3) {
        return fromPointerBuilderBlobDefault.fromPointerBuilderBlobDefault(this.segment, this.pointers + n, byteBuffer, n2, n3);
    }

    protected final <T> T _initPointerField(FromPointerBuilder<T> fromPointerBuilder, int n, int n2) {
        return fromPointerBuilder.initFromPointerBuilder(this.segment, this.pointers + n, n2);
    }

    protected final <Builder, Reader> void _setPointerField(SetPointerBuilder<Builder, Reader> setPointerBuilder, int n, Reader Reader2) {
        setPointerBuilder.setPointerBuilder(this.segment, this.pointers + n, Reader2);
    }

    public static interface Factory<T> {
        public T constructBuilder(SegmentBuilder var1, int var2, int var3, int var4, short var5);

        public StructSize structSize();
    }
}

