/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2HeaderTable;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.internal.hpack.Encoder;
import io.netty.util.internal.ObjectUtil;

public class DefaultHttp2HeadersEncoder
implements Http2HeadersEncoder,
Http2HeadersEncoder.Configuration {
    private final Encoder encoder;
    private final Http2HeadersEncoder.SensitivityDetector sensitivityDetector;
    private final Http2HeaderTable headerTable;
    private final ByteBuf tableSizeChangeOutput = Unpooled.buffer();

    public DefaultHttp2HeadersEncoder() {
        this(NEVER_SENSITIVE);
    }

    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        this(sensitivityDetector, new Encoder());
    }

    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder.SensitivityDetector sensitivityDetector, boolean ignoreMaxHeaderListSize) {
        this(sensitivityDetector, new Encoder(ignoreMaxHeaderListSize));
    }

    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder.SensitivityDetector sensitivityDetector, boolean ignoreMaxHeaderListSize, int dynamicTableArraySizeHint) {
        this(sensitivityDetector, new Encoder(ignoreMaxHeaderListSize, dynamicTableArraySizeHint));
    }

    DefaultHttp2HeadersEncoder(Http2HeadersEncoder.SensitivityDetector sensitivityDetector, Encoder encoder) {
        this.sensitivityDetector = ObjectUtil.checkNotNull(sensitivityDetector, "sensitiveDetector");
        this.encoder = ObjectUtil.checkNotNull(encoder, "encoder");
        this.headerTable = new Http2HeaderTableEncoder();
    }

    @Override
    public void encodeHeaders(Http2Headers headers, ByteBuf buffer) throws Http2Exception {
        try {
            if (this.tableSizeChangeOutput.isReadable()) {
                buffer.writeBytes(this.tableSizeChangeOutput);
                this.tableSizeChangeOutput.clear();
            }
            this.encoder.encodeHeaders(buffer, headers, this.sensitivityDetector);
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, t, "Failed encoding headers block: %s", t.getMessage());
        }
    }

    @Override
    public Http2HeaderTable headerTable() {
        return this.headerTable;
    }

    @Override
    public Http2HeadersEncoder.Configuration configuration() {
        return this;
    }

    private final class Http2HeaderTableEncoder
    implements Http2HeaderTable {
        private Http2HeaderTableEncoder() {
        }

        @Override
        public void maxHeaderTableSize(long max) throws Http2Exception {
            DefaultHttp2HeadersEncoder.this.encoder.setMaxHeaderTableSize(DefaultHttp2HeadersEncoder.this.tableSizeChangeOutput, max);
        }

        @Override
        public long maxHeaderTableSize() {
            return DefaultHttp2HeadersEncoder.this.encoder.getMaxHeaderTableSize();
        }

        @Override
        public void maxHeaderListSize(long max) throws Http2Exception {
            DefaultHttp2HeadersEncoder.this.encoder.setMaxHeaderListSize(max);
        }

        @Override
        public long maxHeaderListSize() {
            return DefaultHttp2HeadersEncoder.this.encoder.getMaxHeaderListSize();
        }
    }
}

