/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.client;

import io.goshawkdb.client.Connection;
import io.goshawkdb.client.MessageReaderRefCount;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.capnproto.MessageBuilder;
import org.capnproto.MessageReader;
import org.capnproto.ReaderOptions;

final class CapnProtoCodec
extends ByteToMessageCodec<MessageBuilder> {
    private static final int MAX_SEGMENT_NUMBER = 1024;
    private static final int MAX_TOTAL_SIZE = 0x40000000;
    private final Connection conn;

    CapnProtoCodec(Connection connection) {
        this.conn = connection;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.conn.disconnected();
        super.channelInactive(ctx);
    }

    protected void encode(ChannelHandlerContext ctx, MessageBuilder msg, ByteBuf out) throws Exception {
        ByteBuffer[] segments = msg.getSegmentsForOutput();
        out.writeIntLE(segments.length - 1);
        for (ByteBuffer seg : segments) {
            out.writeIntLE(seg.limit() / 8);
        }
        if (segments.length % 2 == 0) {
            out.writeIntLE(0);
        }
        for (ByteBuffer seg : segments) {
            out.writeBytes(seg);
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int available = in.readableBytes();
        if (available < 4) {
            return;
        }
        in.markReaderIndex();
        int segCount = in.readIntLE() + 1;
        available -= 4;
        if (1 > segCount || segCount > 1024) {
            in.resetReaderIndex();
            throw new IOException("Too many segments: " + segCount);
        }
        int headerSize = 4 * segCount;
        if (available < headerSize) {
            in.resetReaderIndex();
            return;
        }
        int[] segSizes = new int[segCount];
        available -= headerSize;
        int total = 0;
        for (int idx = 0; idx < segCount; ++idx) {
            int segSize;
            segSizes[idx] = segSize = in.readIntLE() * 8;
            if ((total += segSize) <= 0x40000000) continue;
            in.resetReaderIndex();
            throw new IOException("Too much data: " + total);
        }
        if (segCount % 2 == 0) {
            if (available < 4) {
                in.resetReaderIndex();
                return;
            }
            in.readIntLE();
            available -= 4;
        }
        if (available < total) {
            in.resetReaderIndex();
            return;
        }
        int readerIndex = in.readerIndex();
        ByteBuffer[] segmentSlices = new ByteBuffer[segCount];
        for (int idx = 0; idx < segSizes.length; ++idx) {
            int segSize = segSizes[idx];
            ByteBuffer buf = in.nioBuffer(readerIndex, segSize);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            segmentSlices[idx] = buf;
            readerIndex += segSize;
        }
        in.readerIndex(readerIndex);
        out.add(new MessageReaderRefCount(in, new MessageReader(segmentSlices, ReaderOptions.DEFAULT_READER_OPTIONS)));
    }
}

