/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.client;

import io.goshawkdb.client.GoshawkObj;
import io.goshawkdb.client.MessageReaderRefCount;
import io.goshawkdb.client.Transaction;
import io.goshawkdb.client.TxnId;
import java.nio.ByteBuffer;

class ObjectState {
    final GoshawkObj obj;
    ObjectState parent = null;
    Transaction<?> transaction = null;
    TxnId curVersion = null;
    ByteBuffer curValue = null;
    MessageReaderRefCount curValueRef = null;
    GoshawkObj[] curObjectRefs = null;
    final boolean create;
    boolean read = false;
    boolean write = false;

    ObjectState(GoshawkObj gObj, Transaction<?> txn, ByteBuffer val, MessageReaderRefCount valRef, GoshawkObj[] refs, boolean created) {
        this.obj = gObj;
        this.create = created;
        this.transaction = txn;
        this.curValue = GoshawkObj.cloneByteBuffer(val).asReadOnlyBuffer();
        this.curValueRef = valRef;
        if (this.curValueRef != null) {
            this.curValueRef.retain();
        }
        if (refs == null) {
            this.curObjectRefs = new GoshawkObj[0];
        } else {
            this.curObjectRefs = new GoshawkObj[refs.length];
            System.arraycopy(refs, 0, this.curObjectRefs, 0, refs.length);
        }
    }

    ObjectState(GoshawkObj gObj, Transaction<?> txn) {
        this.obj = gObj;
        this.create = false;
        this.transaction = txn;
    }

    ObjectState clone(Transaction<?> txn) {
        ObjectState os = new ObjectState(this.obj, txn, this.curValue, this.curValueRef, this.curObjectRefs, this.create);
        os.parent = this;
        os.curVersion = this.curVersion;
        os.read = this.read;
        os.write = this.write;
        return os;
    }
}

