/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.capnproto.Arena;
import org.capnproto.DecodeException;
import org.capnproto.SegmentReader;

public final class ReaderArena
implements Arena {
    public long limit;
    public final ArrayList<SegmentReader> segments;

    public ReaderArena(ByteBuffer[] byteBufferArray, long l) {
        this.limit = l;
        this.segments = new ArrayList();
        for (int i = 0; i < byteBufferArray.length; ++i) {
            this.segments.add(new SegmentReader(byteBufferArray[i], this));
        }
    }

    @Override
    public SegmentReader tryGetSegment(int n) {
        return this.segments.get(n);
    }

    @Override
    public final void checkReadLimit(int n) {
        if ((long)n > this.limit) {
            throw new DecodeException("Read limit exceeded.");
        }
        this.limit -= (long)n;
    }
}

