/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.capnproto.Arena;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;

public final class BuilderArena
implements Arena {
    public static final int SUGGESTED_FIRST_SEGMENT_WORDS = 1024;
    public static final AllocationStrategy SUGGESTED_ALLOCATION_STRATEGY = AllocationStrategy.GROW_HEURISTICALLY;
    public final ArrayList<SegmentBuilder> segments = new ArrayList();
    public int nextSize;
    public final AllocationStrategy allocationStrategy;

    public BuilderArena(int n, AllocationStrategy allocationStrategy) {
        this.nextSize = n;
        this.allocationStrategy = allocationStrategy;
        SegmentBuilder segmentBuilder = new SegmentBuilder(ByteBuffer.allocate(n * 8), this);
        segmentBuilder.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.segments.add(segmentBuilder);
    }

    @Override
    public final SegmentReader tryGetSegment(int n) {
        return this.segments.get(n);
    }

    public final SegmentBuilder getSegment(int n) {
        return this.segments.get(n);
    }

    @Override
    public final void checkReadLimit(int n) {
    }

    public AllocateResult allocate(int n) {
        int n2 = this.segments.size();
        int n3 = this.segments.get(n2 - 1).allocate(n);
        if (n3 != -1) {
            return new AllocateResult(this.segments.get(n2 - 1), n3);
        }
        int n4 = Math.max(n, this.nextSize);
        SegmentBuilder segmentBuilder = new SegmentBuilder(ByteBuffer.allocate(n4 * 8), this);
        switch (this.allocationStrategy) {
            case GROW_HEURISTICALLY: {
                this.nextSize += n4;
                break;
            }
        }
        segmentBuilder.buffer.order(ByteOrder.LITTLE_ENDIAN);
        segmentBuilder.id = n2;
        this.segments.add(segmentBuilder);
        return new AllocateResult(segmentBuilder, segmentBuilder.allocate(n));
    }

    public final ByteBuffer[] getSegmentsForOutput() {
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.segments.size()];
        for (int i = 0; i < this.segments.size(); ++i) {
            SegmentBuilder segmentBuilder = this.segments.get(i);
            segmentBuilder.buffer.rewind();
            ByteBuffer byteBuffer = segmentBuilder.buffer.slice();
            byteBuffer.limit(segmentBuilder.currentSize() * 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBufferArray[i] = byteBuffer;
        }
        return byteBufferArray;
    }

    public static class AllocateResult {
        public final SegmentBuilder segment;
        public final int offset;

        public AllocateResult(SegmentBuilder segmentBuilder, int n) {
            this.segment = segmentBuilder;
            this.offset = n;
        }
    }

    public static enum AllocationStrategy {
        FIXED_SIZE,
        GROW_HEURISTICALLY;

    }
}

