/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.client;

import io.goshawkdb.client.ConnectionFactory;
import io.goshawkdb.client.MessageReaderRefCount;
import io.goshawkdb.client.capnp.ConnectionCap;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import org.capnproto.FromPointerBuilder;
import org.capnproto.FromPointerReader;
import org.capnproto.MessageBuilder;

final class Heartbeater
extends ChannelDuplexHandler
implements TimerTask {
    private final Object lock = new Object();
    private final ChannelHandlerContext context;
    private final MessageBuilder heartbeat;
    private int missedHeartbeats = 0;
    private boolean mustSendBeat = true;
    private Timeout timeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Heartbeater(ChannelHandlerContext ctx) {
        this.context = ctx;
        this.heartbeat = new MessageBuilder();
        ConnectionCap.ClientMessage.Builder msg = (ConnectionCap.ClientMessage.Builder)((Object)this.heartbeat.initRoot((FromPointerBuilder)ConnectionCap.ClientMessage.factory));
        msg.setHeartbeat(null);
        Object object = this.lock;
        synchronized (object) {
            this.timeout = ConnectionFactory.timer.newTimeout((TimerTask)this, 2L, ConnectionFactory.HEARTBEAT_INTERVAL_UNIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.timeout != null) {
                this.timeout.cancel();
            }
        }
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof MessageReaderRefCount) {
            Object object = this.lock;
            synchronized (object) {
                this.missedHeartbeats = 0;
            }
            MessageReaderRefCount read = (MessageReaderRefCount)msg;
            ConnectionCap.ClientMessage.Reader h = (ConnectionCap.ClientMessage.Reader)((Object)read.msg.getRoot((FromPointerReader)ConnectionCap.ClientMessage.factory));
            if (h != null && h.isHeartbeat()) {
                read.release();
                return;
            }
        }
        super.channelRead(ctx, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.mustSendBeat = false;
        }
        super.write(ctx, msg, promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Timeout t) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.missedHeartbeats == 2) {
                System.out.println("Too many missing heartbeats. Closing connection.");
                if (this.context != null) {
                    this.context.channel().close();
                }
                return;
            }
            ++this.missedHeartbeats;
            if (this.mustSendBeat) {
                this.context.writeAndFlush((Object)this.heartbeat);
            } else {
                this.mustSendBeat = true;
            }
            this.timeout = t.timer().newTimeout((TimerTask)this, 2L, ConnectionFactory.HEARTBEAT_INTERVAL_UNIT);
        }
    }
}

