/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.client;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;

public class Certs {
    public static final String CIPHER = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256";
    private final KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
    private KeyStore keyStore;
    private X509CertificateHolder clientCertificateHolder;
    private X509Certificate clientCertificate;
    private PEMKeyPair clientKeyPair;
    private PrivateKey clientPrivateKey;

    private Certs ensureKeyStore() throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        if (this.keyStore == null) {
            this.keyStore = KeyStore.getInstance("JKS");
            this.keyStore.load(null, null);
        }
        return this;
    }

    public Certs setKeyStore(KeyStore ks) {
        this.keyStore = ks;
        return this;
    }

    private TrustManagerFactory getTrustManagerFactory() throws NoSuchAlgorithmException, KeyStoreException {
        if (this.keyStore == null) {
            return InsecureTrustManagerFactory.INSTANCE;
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.keyStore);
        return trustManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certs addClusterCertificate(String alias, InputStream is) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        try {
            CertificateFactory clusterCertFact = CertificateFactory.getInstance("X.509");
            Certificate clusterCert = clusterCertFact.generateCertificate(is);
            this.ensureKeyStore();
            this.keyStore.setCertificateEntry(alias, clusterCert);
            Certs certs = this;
            return certs;
        }
        finally {
            is.close();
        }
    }

    public Certs addClusterCertificate(String alias, byte[] cert) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return this.addClusterCertificate(alias, new ByteArrayInputStream(cert));
    }

    public Certs setClientCertificateHolder(X509CertificateHolder certHolder) throws CertificateException, InvalidKeySpecException, InvalidKeyException, IOException {
        this.clientCertificateHolder = certHolder;
        this.clientCertificate = null;
        this.verifyClient();
        return this;
    }

    public Certs setClientKeyPair(PEMKeyPair keyPair) throws CertificateException, InvalidKeySpecException, InvalidKeyException, IOException {
        this.clientKeyPair = keyPair;
        this.clientPrivateKey = null;
        this.verifyClient();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certs parseClientPEM(Reader reader) throws CertificateException, InvalidKeySpecException, InvalidKeyException, IOException {
        try (PEMParser parser = new PEMParser(reader);){
            Object o;
            boolean foundCert = false;
            boolean foundKeyPair = false;
            while (!((o = parser.readObject()) == null || foundCert && foundKeyPair)) {
                if (o instanceof X509CertificateHolder) {
                    this.setClientCertificateHolder((X509CertificateHolder)o);
                    foundCert = true;
                }
                if (!(o instanceof PEMKeyPair)) continue;
                this.setClientKeyPair((PEMKeyPair)o);
                foundKeyPair = true;
            }
        }
        return this;
    }

    private void verifyClient() throws CertificateException, InvalidKeyException, IOException, InvalidKeySpecException {
        SubjectPublicKeyInfo clientCertificatePubKeyInfo = null;
        SubjectPublicKeyInfo clientKeyPairPubKeyInfo = null;
        if (this.clientCertificateHolder != null && !X9ObjectIdentifiers.id_ecPublicKey.equals((Object)(clientCertificatePubKeyInfo = this.clientCertificateHolder.getSubjectPublicKeyInfo()).getAlgorithm().getAlgorithm())) {
            this.clientCertificateHolder = null;
            throw new CertificateException("ClientCertificateHolder must contain an EC public key");
        }
        if (this.clientKeyPair != null && !X9ObjectIdentifiers.id_ecPublicKey.equals((Object)(clientKeyPairPubKeyInfo = this.clientKeyPair.getPublicKeyInfo()).getAlgorithm().getAlgorithm())) {
            this.clientKeyPair = null;
            throw new InvalidKeyException("ClientKeyPair's Public Key must be an EC public key");
        }
        if (this.clientCertificateHolder != null && this.clientKeyPair != null) {
            PublicKey clientCertificatePublicKey = this.keyFactory.generatePublic(new X509EncodedKeySpec(clientCertificatePubKeyInfo.getEncoded()));
            if (!(clientCertificatePublicKey instanceof BCECPublicKey)) {
                this.clientCertificateHolder = null;
                throw new CertificateException("ClientCertificateHolder must contain an EC public key");
            }
            ECPoint clientCertificatePublicKeyQ = ((BCECPublicKey)clientCertificatePublicKey).getQ();
            PublicKey clientKeyPairPublicKey = this.keyFactory.generatePublic(new X509EncodedKeySpec(clientKeyPairPubKeyInfo.getEncoded()));
            if (!(clientKeyPairPublicKey instanceof BCECPublicKey)) {
                this.clientKeyPair = null;
                throw new InvalidKeyException("ClientKeyPair must contain an EC public key");
            }
            ECPoint clientKeyPairPublicKeyQ = ((BCECPublicKey)clientKeyPairPublicKey).getQ();
            if (!clientCertificatePublicKeyQ.equals(clientKeyPairPublicKeyQ)) {
                this.clientCertificateHolder = null;
                this.clientKeyPair = null;
                throw new InvalidKeyException("ClientKeyPair's public key does not match the public key in ClientCertificateHolder");
            }
            this.clientPrivateKey = this.keyFactory.generatePrivate(new PKCS8EncodedKeySpec(this.clientKeyPair.getPrivateKeyInfo().getEncoded()));
            this.clientCertificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(this.clientCertificateHolder);
        }
    }

    SslContext buildClientSslContext() throws KeyStoreException, NoSuchAlgorithmException, SSLException {
        if (this.clientCertificateHolder == null || this.clientKeyPair == null) {
            throw new IllegalStateException("ClientCertificateHolder and ClientKeyPair must be provided");
        }
        return SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(this.getTrustManagerFactory()).ciphers(Arrays.asList(CIPHER)).keyManager(this.clientPrivateKey, new X509Certificate[]{this.clientCertificate}).sessionCacheSize(0L).sessionTimeout(0L).build();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

