/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.client;

import io.goshawkdb.client.MessageReaderRefCount;
import io.goshawkdb.client.TxnId;
import io.goshawkdb.client.VarUUId;
import io.goshawkdb.client.capnp.TransactionCap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.capnproto.Data;
import org.capnproto.DataList;
import org.capnproto.StructList;

final class Cache {
    private final Object lock = new Object();
    private final HashMap<VarUUId, ValueRef> m = new HashMap();

    Cache() {
    }

    void clear() {
        this.m.forEach((varUUId, valueRef) -> {
            if (valueRef.reader != null) {
                valueRef.reader.release();
            }
        });
        this.m.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueRef get(VarUUId vUUId) {
        Object object = this.lock;
        synchronized (object) {
            return this.m.get(vUUId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFromTxnCommit(TransactionCap.ClientTxn.Reader txn, TxnId txnId) {
        Iterator actionIt = txn.getActions().iterator();
        Object object = this.lock;
        synchronized (object) {
            while (actionIt.hasNext()) {
                TransactionCap.ClientAction.Reader action = (TransactionCap.ClientAction.Reader)((Object)actionIt.next());
                VarUUId vUUId = new VarUUId(action.getVarId().asByteBuffer());
                switch (action.which()) {
                    case WRITE: {
                        TransactionCap.ClientAction.Write.Reader write = action.getWrite();
                        DataList.Reader refs = write.getReferences();
                        this.updateFromWrite(txnId, vUUId, write.getValue(), refs, null);
                        break;
                    }
                    case READWRITE: {
                        TransactionCap.ClientAction.Readwrite.Reader rw = action.getReadwrite();
                        DataList.Reader refs = rw.getReferences();
                        this.updateFromWrite(txnId, vUUId, rw.getValue(), refs, null);
                        break;
                    }
                    case CREATE: {
                        TransactionCap.ClientAction.Create.Reader create = action.getCreate();
                        DataList.Reader refs = create.getReferences();
                        this.updateFromWrite(txnId, vUUId, create.getValue(), refs, null);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<VarUUId> updateFromTxnAbort(StructList.Reader<TransactionCap.ClientUpdate.Reader> updates, MessageReaderRefCount reader) {
        ArrayList<VarUUId> modifiedVars = new ArrayList<VarUUId>(updates.size());
        Iterator updatesIt = updates.iterator();
        Object object = this.lock;
        synchronized (object) {
            while (updatesIt.hasNext()) {
                TransactionCap.ClientUpdate.Reader update = (TransactionCap.ClientUpdate.Reader)((Object)updatesIt.next());
                TxnId txnId = new TxnId(update.getVersion().asByteBuffer());
                StructList.Reader<TransactionCap.ClientAction.Reader> actions = update.getActions();
                actions.forEach(action -> {
                    VarUUId vUUId = new VarUUId(action.getVarId().asByteBuffer());
                    switch (action.which()) {
                        case DELETE: {
                            this.updateFromDelete(vUUId, txnId);
                            break;
                        }
                        case WRITE: {
                            TransactionCap.ClientAction.Write.Reader write = action.getWrite();
                            DataList.Reader refs = write.getReferences();
                            if (!this.updateFromWrite(txnId, vUUId, write.getValue(), refs, reader)) break;
                            modifiedVars.add(vUUId);
                            break;
                        }
                    }
                });
            }
        }
        return modifiedVars;
    }

    private void updateFromDelete(VarUUId vUUId, TxnId txnId) {
        ValueRef vr = this.m.remove(vUUId);
        if (vr == null) {
            throw new IllegalStateException("Divergence discovered on deletion of " + vUUId + ": server thinks we had it cached, but we don't!");
        }
        if (vr.version.equals(txnId)) {
            throw new IllegalStateException("Divergence discovered on deletion of " + vUUId + ": server thinks we don't have " + txnId + " but we do!");
        }
        if (vr.reader != null) {
            vr.reader.release();
        }
    }

    private boolean updateFromWrite(TxnId txnId, VarUUId vUUId, Data.Reader value, DataList.Reader refs, MessageReaderRefCount reader) {
        ValueRef vr = this.m.get(vUUId);
        boolean missing = vr == null;
        VarUUId[] references = new VarUUId[refs.size()];
        if (missing) {
            vr = new ValueRef();
            vr.references = references;
            this.m.put(vUUId, vr);
        } else {
            if (vr.version.equals(txnId)) {
                throw new IllegalStateException("Divergence discovered on update of " + vUUId + ": server thinks we don't have " + txnId + " but we do!");
            }
            vr.references = references;
        }
        vr.version = txnId;
        vr.value = value.asByteBuffer().asReadOnlyBuffer().slice();
        if (reader != null) {
            reader.retain();
        }
        if (vr.reader != null) {
            vr.reader.release();
        }
        vr.reader = reader;
        Iterator refsIt = refs.iterator();
        int idx = 0;
        while (refsIt.hasNext()) {
            vr.references[idx] = new VarUUId(((Data.Reader)refsIt.next()).asByteBuffer());
            ++idx;
        }
        return !missing;
    }

    static class ValueRef {
        TxnId version;
        ByteBuffer value;
        VarUUId[] references;
        MessageReaderRefCount reader;

        ValueRef() {
        }
    }
}

