/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import org.capnproto.DecodeException;
import org.capnproto.MessageBuilder;
import org.capnproto.MessageReader;
import org.capnproto.ReaderOptions;

public final class Serialize {
    static ByteBuffer makeByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.mark();
        return byteBuffer;
    }

    public static void fillBuffer(ByteBuffer byteBuffer, ReadableByteChannel readableByteChannel) throws IOException {
        while (byteBuffer.hasRemaining()) {
            int n = readableByteChannel.read(byteBuffer);
            if (n >= 0) continue;
            throw new IOException("premature EOF");
        }
    }

    public static MessageReader read(ReadableByteChannel readableByteChannel) throws IOException {
        return Serialize.read(readableByteChannel, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader read(ReadableByteChannel readableByteChannel, ReaderOptions readerOptions) throws IOException {
        int n;
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = Serialize.makeByteBuffer(8);
        Serialize.fillBuffer(byteBuffer2, readableByteChannel);
        int n2 = 1 + byteBuffer2.getInt(0);
        int n3 = 0;
        if (n2 > 0) {
            n3 = byteBuffer2.getInt(4);
        }
        int n4 = n3;
        if (n2 > 512) {
            throw new IOException("too many segments");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n2 > 1) {
            byteBuffer = Serialize.makeByteBuffer(4 * (n2 & 0xFFFFFFFE));
            Serialize.fillBuffer(byteBuffer, readableByteChannel);
            for (int i = 0; i < n2 - 1; ++i) {
                n = byteBuffer.getInt(i * 4);
                arrayList.add(n);
                n4 += n;
            }
        }
        if ((long)n4 > readerOptions.traversalLimitInWords) {
            throw new DecodeException("Message size exceeds traversal limit.");
        }
        byteBuffer = Serialize.makeByteBuffer(n4 * 8);
        Serialize.fillBuffer(byteBuffer, readableByteChannel);
        ByteBuffer[] byteBufferArray = new ByteBuffer[n2];
        byteBuffer.rewind();
        byteBufferArray[0] = byteBuffer.slice();
        byteBufferArray[0].limit(n3 * 8);
        byteBufferArray[0].order(ByteOrder.LITTLE_ENDIAN);
        n = n3;
        for (int i = 1; i < n2; ++i) {
            byteBuffer.position(n * 8);
            byteBufferArray[i] = byteBuffer.slice();
            byteBufferArray[i].limit((Integer)arrayList.get(i - 1) * 8);
            byteBufferArray[i].order(ByteOrder.LITTLE_ENDIAN);
            n += ((Integer)arrayList.get(i - 1)).intValue();
        }
        return new MessageReader(byteBufferArray, readerOptions);
    }

    public static MessageReader read(ByteBuffer byteBuffer) throws IOException {
        return Serialize.read(byteBuffer, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader read(ByteBuffer byteBuffer, ReaderOptions readerOptions) throws IOException {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = 1 + byteBuffer.getInt();
        if (n > 512) {
            throw new IOException("too many segments");
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[n];
        int n2 = byteBuffer.position();
        int n3 = n * 4;
        int n4 = 7;
        int n5 = n2 + n3 + n4 & ~n4;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            int n7 = byteBuffer.getInt(n2 + i * 4);
            byteBuffer.position(n5 + n6 * 8);
            byteBufferArray[i] = byteBuffer.slice();
            byteBufferArray[i].limit(n7 * 8);
            byteBufferArray[i].order(ByteOrder.LITTLE_ENDIAN);
            n6 += n7;
        }
        byteBuffer.position(n5 + n6 * 8);
        if ((long)n6 > readerOptions.traversalLimitInWords) {
            throw new DecodeException("Message size exceeds traversal limit.");
        }
        return new MessageReader(byteBufferArray, readerOptions);
    }

    public static long computeSerializedSizeInWords(MessageBuilder messageBuilder) {
        ByteBuffer[] byteBufferArray = messageBuilder.getSegmentsForOutput();
        long l = 0L;
        l += 4L;
        if ((l += (long)(byteBufferArray.length * 4)) % 8L != 0L) {
            l += 4L;
        }
        for (int i = 0; i < byteBufferArray.length; ++i) {
            ByteBuffer byteBuffer = byteBufferArray[i];
            l += (long)byteBuffer.limit();
        }
        return l / 8L;
    }

    public static void write(WritableByteChannel writableByteChannel, MessageBuilder messageBuilder) throws IOException {
        ByteBuffer[] byteBufferArray = messageBuilder.getSegmentsForOutput();
        int n = byteBufferArray.length + 2 & 0xFFFFFFFE;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 * n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(0, byteBufferArray.length - 1);
        for (int i = 0; i < byteBufferArray.length; ++i) {
            byteBuffer.putInt(4 * (i + 1), byteBufferArray[i].limit() / 8);
        }
        while (byteBuffer.hasRemaining()) {
            writableByteChannel.write(byteBuffer);
        }
        for (ByteBuffer byteBuffer2 : byteBufferArray) {
            while (byteBuffer2.hasRemaining()) {
                writableByteChannel.write(byteBuffer2);
            }
        }
    }
}

