/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.client;

import io.goshawkdb.client.Cache;
import io.goshawkdb.client.Connection;
import io.goshawkdb.client.ConnectionFactory;
import io.goshawkdb.client.GoshawkObj;
import io.goshawkdb.client.ObjectState;
import io.goshawkdb.client.TransactionFun;
import io.goshawkdb.client.TransactionRestartRequiredException;
import io.goshawkdb.client.TransactionResult;
import io.goshawkdb.client.TxnId;
import io.goshawkdb.client.TxnSubmissionResult;
import io.goshawkdb.client.VarUUId;
import io.goshawkdb.client.capnp.ConnectionCap;
import io.goshawkdb.client.capnp.TransactionCap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.capnproto.Data;
import org.capnproto.DataList;
import org.capnproto.FromPointerBuilder;
import org.capnproto.MessageBuilder;
import org.capnproto.StructList;

public class Transaction<Result> {
    final Cache cache;
    private final HashMap<VarUUId, GoshawkObj> objs = new HashMap();
    private final TransactionFun<Result> fun;
    private final Connection conn;
    private final VarUUId root;
    private final Transaction<?> parent;
    boolean resetInProgress = false;

    Transaction(TransactionFun<Result> fun, Connection conn, Cache cache, VarUUId root, Transaction<?> parent) {
        this.fun = fun;
        this.conn = conn;
        this.cache = cache;
        this.root = root;
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionResult<Result> run() throws Throwable {
        try {
            Object result;
            block11: {
                TxnId txnId;
                while (true) {
                    if (this.resetInProgress) {
                        if (this.parent == null || !this.parent.resetInProgress) {
                            this.resetInProgress = false;
                        } else {
                            throw TransactionRestartRequiredException.e;
                        }
                    }
                    this.resetObjects();
                    result = null;
                    try {
                        result = this.fun.Run(this);
                    }
                    catch (TransactionRestartRequiredException transactionRestartRequiredException) {
                        // empty catch block
                    }
                    if (this.resetInProgress) {
                        if (this.parent == null || !this.parent.resetInProgress) continue;
                        throw TransactionRestartRequiredException.e;
                    }
                    if (this.parent != null) break block11;
                    txnId = this.submitToServer();
                    if (txnId != null) break;
                }
                TransactionResult<Object> transactionResult = new TransactionResult<Object>(result, txnId);
                return transactionResult;
            }
            this.moveObjsToParent();
            TransactionResult<Object> transactionResult = new TransactionResult<Object>(result, null);
            return transactionResult;
        }
        finally {
            this.resetObjects();
        }
    }

    public void retry() {
        if (this.resetInProgress) {
            throw TransactionRestartRequiredException.e;
        }
        this.submitRetryTransaction();
        throw TransactionRestartRequiredException.e;
    }

    public GoshawkObj getRoot() {
        return this.getObject(this.root);
    }

    public GoshawkObj createObject(ByteBuffer value, GoshawkObj ... references) {
        if (this.resetInProgress) {
            throw TransactionRestartRequiredException.e;
        }
        GoshawkObj obj = new GoshawkObj(this.conn.nextVarUUId(), this.conn);
        this.objs.put(obj.id, obj);
        obj.state = new ObjectState(obj, this, value, null, references, true);
        return obj;
    }

    public GoshawkObj getObject(VarUUId vUUId) {
        if (this.resetInProgress) {
            throw TransactionRestartRequiredException.e;
        }
        return this.getObject(vUUId, true);
    }

    private GoshawkObj getObject(VarUUId vUUId, boolean addToTxn) {
        GoshawkObj obj = this.objs.get(vUUId);
        if (obj != null) {
            return obj;
        }
        if (this.parent != null && (obj = super.getObject(vUUId, false)) != null) {
            if (addToTxn) {
                obj.state = obj.state.clone(this);
                this.objs.put(vUUId, obj);
            }
            return obj;
        }
        if (addToTxn) {
            obj = new GoshawkObj(vUUId, this.conn);
            this.objs.put(vUUId, obj);
            obj.state = new ObjectState(obj, this);
            return obj;
        }
        return null;
    }

    boolean varsUpdated(List<VarUUId> modifiedVars) {
        if (this.parent != null && this.parent.varsUpdated(modifiedVars)) {
            this.resetInProgress = true;
            return true;
        }
        if (this.resetInProgress) {
            return true;
        }
        if (modifiedVars != null) {
            for (VarUUId vUUId : modifiedVars) {
                GoshawkObj obj = this.objs.get(vUUId);
                if (obj == null || obj.state.transaction != this || !obj.state.read) continue;
                this.resetInProgress = true;
                return true;
            }
        }
        return false;
    }

    private void resetObjects() {
        this.objs.forEach((vUUId, obj) -> {
            if (obj.state.transaction == this) {
                if (obj.state.curValueRef != null) {
                    obj.state.curValueRef.release();
                }
                obj.state = obj.state.parent;
            }
        });
        this.objs.clear();
    }

    private void moveObjsToParent() {
        HashMap<VarUUId, GoshawkObj> pObjs = this.parent.objs;
        this.objs.forEach((vUUId, obj) -> {
            ObjectState state = obj.state;
            if (state.transaction == this) {
                state.transaction = this.parent;
                if (state.parent != null && state.parent.transaction == this.parent) {
                    if (state.parent.curValueRef != null) {
                        state.parent.curValueRef.release();
                    }
                    state.parent = state.parent.parent;
                }
                pObjs.putIfAbsent((VarUUId)vUUId, (GoshawkObj)obj);
            }
        });
    }

    private void submitRetryTransaction() {
        HashMap reads = new HashMap();
        Transaction<?> ancestor = this;
        while (ancestor != null) {
            Transaction<?> ancestorFinal = ancestor;
            HashMap<VarUUId, GoshawkObj> objs = ancestor.objs;
            objs.forEach((vUUId, obj) -> {
                if (obj.state.transaction == ancestorFinal && obj.state.read) {
                    reads.putIfAbsent(vUUId, obj.state);
                }
            });
            ancestor = ancestor.parent;
        }
        if (reads.size() > 0) {
            MessageBuilder msg = new MessageBuilder();
            ConnectionCap.ClientMessage.Builder builder = (ConnectionCap.ClientMessage.Builder)((Object)msg.initRoot((FromPointerBuilder)ConnectionCap.ClientMessage.factory));
            TransactionCap.ClientTxn.Builder cTxn = builder.initClientTxnSubmission();
            cTxn.setRetry(true);
            StructList.Builder<TransactionCap.ClientAction.Builder> actions = cTxn.initActions(reads.size());
            Iterator stateIt = reads.values().iterator();
            int idx = 0;
            while (stateIt.hasNext()) {
                ObjectState state = (ObjectState)stateIt.next();
                TransactionCap.ClientAction.Builder action = (TransactionCap.ClientAction.Builder)((Object)actions.get(idx));
                action.setVarId(state.obj.id.id);
                action.initRead().setVersion(state.curVersion.id);
                ++idx;
            }
            this.conn.submitTransaction(msg, cTxn);
        }
        ancestor = this;
        while (ancestor != null) {
            ancestor.resetInProgress = true;
            ancestor = ancestor.parent;
        }
    }

    private TxnId submitToServer() {
        int s = this.objs.size();
        ArrayList reads = new ArrayList(s);
        ArrayList writes = new ArrayList(s);
        ArrayList readwrites = new ArrayList(s);
        ArrayList creates = new ArrayList(s);
        this.objs.forEach((vUUId, obj) -> {
            ObjectState state = obj.state;
            if (state.create) {
                creates.add(state);
            } else if (state.read && state.write) {
                readwrites.add(state);
            } else if (state.write) {
                writes.add(state);
            } else if (state.read) {
                reads.add(state);
            }
        });
        int totalLen = reads.size() + writes.size() + readwrites.size() + creates.size();
        if (totalLen == 0) {
            return ConnectionFactory.VERSION_ZERO;
        }
        MessageBuilder msg = new MessageBuilder();
        ConnectionCap.ClientMessage.Builder builder = (ConnectionCap.ClientMessage.Builder)((Object)msg.initRoot((FromPointerBuilder)ConnectionCap.ClientMessage.factory));
        TransactionCap.ClientTxn.Builder cTxn = builder.initClientTxnSubmission();
        cTxn.setRetry(false);
        StructList.Builder<TransactionCap.ClientAction.Builder> actions = cTxn.initActions(totalLen);
        ArrayList lists = new ArrayList(4);
        lists.add(reads);
        lists.add(writes);
        lists.add(readwrites);
        lists.add(creates);
        int idx = 0;
        for (ArrayList arrayList : lists) {
            for (ObjectState state : arrayList) {
                DataList.Builder refs;
                TransactionCap.ClientAction.Builder action = (TransactionCap.ClientAction.Builder)((Object)actions.get(idx));
                ++idx;
                action.setVarId(state.obj.id.id);
                if (arrayList == reads) {
                    action.initRead().setVersion(state.curVersion.id);
                    continue;
                }
                if (arrayList == writes) {
                    TransactionCap.ClientAction.Write.Builder write = action.initWrite();
                    refs = write.initReferences(state.curObjectRefs.length);
                    write.setValue(new Data.Reader(state.curValue, 0, state.curValue.limit()));
                } else if (arrayList == readwrites) {
                    TransactionCap.ClientAction.Readwrite.Builder readwrite = action.initReadwrite();
                    refs = readwrite.initReferences(state.curObjectRefs.length);
                    readwrite.setVersion(state.curVersion.id);
                    readwrite.setValue(new Data.Reader(state.curValue, 0, state.curValue.limit()));
                } else {
                    TransactionCap.ClientAction.Create.Builder create = action.initCreate();
                    refs = create.initReferences(state.curObjectRefs.length);
                    create.setValue(new Data.Reader(state.curValue, 0, state.curValue.limit()));
                }
                int idy = 0;
                for (GoshawkObj ref : state.curObjectRefs) {
                    refs.set(idy, new Data.Reader(ref.id.id));
                    ++idy;
                }
            }
        }
        TxnSubmissionResult txnSubmissionResult = this.conn.submitTransaction(msg, cTxn);
        if (txnSubmissionResult.outcome.which() == TransactionCap.ClientTxnOutcome.Which.ABORT) {
            return null;
        }
        return new TxnId(txnSubmissionResult.outcome.getFinalId().asByteBuffer());
    }
}

