/*
 * Decompiled with CFR 0.152.
 */
package io.goshawkdb.client;

import io.goshawkdb.client.AwaitHandshake;
import io.goshawkdb.client.AwaitServerHello;
import io.goshawkdb.client.Cache;
import io.goshawkdb.client.CapnProtoCodec;
import io.goshawkdb.client.Certs;
import io.goshawkdb.client.ConnectionFactory;
import io.goshawkdb.client.Heartbeater;
import io.goshawkdb.client.MessageReaderRefCount;
import io.goshawkdb.client.Transaction;
import io.goshawkdb.client.TransactionFun;
import io.goshawkdb.client.TransactionResult;
import io.goshawkdb.client.TxnId;
import io.goshawkdb.client.TxnSubmissionResult;
import io.goshawkdb.client.VarUUId;
import io.goshawkdb.client.capnp.ConnectionCap;
import io.goshawkdb.client.capnp.TransactionCap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.capnproto.FromPointerReader;
import org.capnproto.MessageBuilder;

public class Connection {
    final Certs certs;
    private final Object lock = new Object();
    private final String host;
    private final int port;
    private final Bootstrap bootstrap;
    private final Cache cache = new Cache();
    private TxnSubmissionResult liveTxn = null;
    private final ChannelDuplexHandler txnSubmitter = new TxnSubmitter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof MessageReaderRefCount) {
                MessageReaderRefCount read = (MessageReaderRefCount)msg;
                ConnectionCap.ClientMessage.Reader result = (ConnectionCap.ClientMessage.Reader)((Object)read.msg.getRoot((FromPointerReader)ConnectionCap.ClientMessage.factory));
                if (result.isClientTxnOutcome()) {
                    ctx.pipeline().remove((ChannelHandler)this);
                    TransactionCap.ClientTxnOutcome.Reader outcome = result.getClientTxnOutcome();
                    Object object = Connection.this.lock;
                    synchronized (object) {
                        if (Connection.this.liveTxn == null) {
                            throw new IllegalStateException("Received txn outcome for unknown txn");
                        }
                        ((Connection)Connection.this).liveTxn.outcome = outcome;
                        ((Connection)Connection.this).liveTxn.reader = read;
                        Connection.this.liveTxn = null;
                        Connection.this.lock.notifyAll();
                    }
                    return;
                }
            }
            super.channelRead(ctx, msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            Object object = Connection.this.lock;
            synchronized (object) {
                if (Connection.this.liveTxn != null) {
                    Connection.this.liveTxn = null;
                    Connection.this.lock.notifyAll();
                }
            }
            super.channelInactive(ctx);
        }
    };
    private ChannelFuture connectFuture;
    private State state;
    private ChannelPipeline pipeline;
    private VarUUId root;
    private ByteBuffer nameSpace;
    private long nextVarUUId;
    private long nextTxnId;
    private Transaction<?> txn;

    Connection(ConnectionFactory cf, Certs c, String h, int p) {
        this.port = p;
        this.host = h;
        this.certs = c;
        this.state = State.AwaitHandshake;
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(cf.group);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)131072);
        this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)131072);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new CapnProtoCodec(Connection.this)});
                pipeline.addLast(new ChannelHandler[]{new AwaitHandshake(Connection.this)});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect() throws InterruptedException {
        ChannelFuture future;
        Object object = this.lock;
        synchronized (object) {
            future = this.connectFuture = this.bootstrap.connect(this.host, this.port);
        }
        future.sync();
        object = this.lock;
        synchronized (object) {
            while (this.root == null && future.channel().isOpen()) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.lock;
        synchronized (object) {
            if (this.connectFuture != null) {
                return this.connectFuture.channel().isActive() && this.root != null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitClose() throws InterruptedException {
        ChannelFuture closeFuture = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.connectFuture != null && (this.connectFuture.channel().isOpen() || this.connectFuture.channel().isActive())) {
                closeFuture = this.connectFuture.channel().closeFuture();
            }
        }
        if (closeFuture != null) {
            closeFuture.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterruptedException {
        ChannelFuture closeFuture = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.connectFuture != null && (this.connectFuture.channel().isOpen() || this.connectFuture.channel().isActive())) {
                closeFuture = this.connectFuture.channel().close();
            }
        }
        if (closeFuture != null) {
            closeFuture.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Result> TransactionResult<Result> runTransaction(TransactionFun<Result> fun) throws Throwable {
        Transaction<?> oldTxn;
        VarUUId r;
        Object object = this.lock;
        synchronized (object) {
            if (this.root == null) {
                throw new IllegalStateException("Unable to start transaction: root object not ready");
            }
            r = this.root;
            oldTxn = this.txn;
        }
        Transaction<Result> curTxn = new Transaction<Result>(fun, this, this.cache, r, oldTxn);
        TransactionResult<Result> transactionResult = this.lock;
        synchronized (transactionResult) {
            this.txn = curTxn;
        }
        try {
            transactionResult = curTxn.run();
            return transactionResult;
        }
        finally {
            Object object2 = this.lock;
            synchronized (object2) {
                this.txn = oldTxn;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VarUUId nextVarUUId() {
        Object object = this.lock;
        synchronized (object) {
            this.nameSpace.putLong(0, this.nextVarUUId);
            this.nameSpace.rewind();
            ++this.nextVarUUId;
            return new VarUUId(this.nameSpace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serverHello(ConnectionCap.HelloClientFromServer.Reader hello, ChannelHandlerContext ctx) throws InterruptedException {
        ByteBuffer rootId = hello.getRootId().asByteBuffer();
        if (rootId.limit() == 0) {
            this.lock.notifyAll();
            throw new IllegalStateException("Cluster is not yet formed; Root object has not been created.");
        }
        if (rootId.limit() != 20) {
            this.lock.notifyAll();
            throw new IllegalStateException("Root object VarUUId is of wrong length!");
        }
        this.nextState(ctx);
        Object object = this.lock;
        synchronized (object) {
            this.pipeline = ctx.pipeline();
            this.root = new VarUUId(rootId);
            this.nameSpace = ByteBuffer.allocate(20);
            this.nameSpace.position(8);
            this.nameSpace.put(hello.getNamespace().asByteBuffer());
            this.nameSpace.order(ByteOrder.BIG_ENDIAN);
            this.nextVarUUId = 0L;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnected() {
        Object object = this.lock;
        synchronized (object) {
            this.root = null;
            this.cache.clear();
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void nextState(ChannelHandlerContext ctx) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case AwaitHandshake: {
                    this.state = State.AwaitServerHello;
                    ctx.pipeline().addLast(new ChannelHandler[]{new AwaitServerHello(this)});
                    break;
                }
                case AwaitServerHello: {
                    this.state = State.Run;
                    ctx.pipeline().addLast(new ChannelHandler[]{new Heartbeater(ctx)});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TxnSubmissionResult submitTransaction(MessageBuilder msg, TransactionCap.ClientTxn.Builder cTxn) {
        Object object = this.lock;
        synchronized (object) {
            TxnSubmissionResult result;
            if (this.state != State.Run) {
                throw new IllegalStateException("Connection in wrong state: " + (Object)((Object)this.state));
            }
            if (this.liveTxn != null) {
                throw new IllegalStateException("Existing live txn");
            }
            this.nameSpace.putLong(0, this.nextTxnId);
            this.nameSpace.rewind();
            byte[] txnIdArray = new byte[20];
            this.nameSpace.get(txnIdArray);
            cTxn.setId(txnIdArray);
            this.liveTxn = result = new TxnSubmissionResult();
            this.pipeline.addLast(new ChannelHandler[]{this.txnSubmitter});
            this.pipeline.writeAndFlush((Object)msg);
            while (result.outcome == null && this.isConnected()) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (result.outcome == null) {
                throw new IllegalStateException("Connection disconnected whilst waiting txn result.");
            }
            if (!Arrays.equals(txnIdArray, result.outcome.getId().toArray())) {
                throw new IllegalStateException("Received txn outcome for wrong txn");
            }
            ByteBuffer finalTxnIdBuf = result.outcome.getFinalId().asByteBuffer();
            finalTxnIdBuf.order(ByteOrder.BIG_ENDIAN);
            long finalTxnIdLong = finalTxnIdBuf.getLong(0);
            if (finalTxnIdLong < this.nextTxnId) {
                throw new IllegalStateException("Final (" + finalTxnIdLong + ") < next (" + this.nextTxnId + ")");
            }
            this.nextTxnId = finalTxnIdLong + 1L;
            TxnId finalTxnId = new TxnId(finalTxnIdBuf);
            switch (result.outcome.which()) {
                case COMMIT: {
                    result.reader.release();
                    this.cache.updateFromTxnCommit(cTxn.asReader(), finalTxnId);
                    break;
                }
                case ABORT: {
                    result.modifiedVars = this.cache.updateFromTxnAbort(result.outcome.getAbort(), result.reader);
                    result.reader.release();
                    break;
                }
                case ERROR: {
                    try {
                        throw new IllegalStateException(result.outcome.getError().toString());
                    }
                    catch (Throwable throwable) {
                        result.reader.release();
                        throw throwable;
                    }
                }
            }
            return result;
        }
    }

    private static enum State {
        AwaitHandshake,
        AwaitServerHello,
        Run;

    }

    @ChannelHandler.Sharable
    private static class TxnSubmitter
    extends ChannelDuplexHandler {
        private TxnSubmitter() {
        }
    }
}

